/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.hint.Hint;

@LoadModule(category=ModuleCategory.BUILDING)
public class MorePottedPlantsModule
extends QuarkModule {
    private static Map<Block, Block> tintedBlocks = new HashMap<Block, Block>();
    @Hint(key="pottable_stuff")
    List<Block> pottableBlocks = Lists.newArrayList();

    @Override
    public void register() {
        this.add(Blocks.f_50444_, "beetroot");
        this.add(Blocks.f_50685_, "berries");
        this.add(Blocks.f_50249_, "carrot");
        this.add(Blocks.f_50491_, "chorus");
        this.add(Blocks.f_50262_, "cocoa_bean");
        FlowerPotBlock grass = this.add(Blocks.f_50034_, "grass");
        this.add(Blocks.f_50358_, "peony");
        FlowerPotBlock largeFern = this.add(Blocks.f_50360_, "large_fern");
        this.add(Blocks.f_50356_, "lilac");
        this.add(Blocks.f_50190_, "melon");
        this.add(Blocks.f_50694_, "nether_sprouts");
        this.add(Blocks.f_50200_, "nether_wart");
        this.add(Blocks.f_50250_, "potato");
        this.add(Blocks.f_50189_, "pumpkin");
        this.add(Blocks.f_50357_, "rose");
        VariantHandler.addFlowerPot(Blocks.f_50567_, "sea_pickle", p -> p.m_60953_(b -> 3));
        FlowerPotBlock sugarCane = this.add(Blocks.f_50130_, "sugar_cane");
        this.add(Blocks.f_50355_, "sunflower");
        FlowerPotBlock tallGrass = this.add(Blocks.f_50359_, "tall_grass");
        this.add(Blocks.f_50704_, "twisting_vines");
        FlowerPotBlock vine = this.add(Blocks.f_50191_, "vine");
        this.add(Blocks.f_50702_, "weeping_vines");
        this.add(Blocks.f_50092_, "wheat");
        VariantHandler.addFlowerPot(Blocks.f_152538_, "cave_vines", p -> p.m_60953_(b -> 14));
        tintedBlocks.put((Block)grass, Blocks.f_50034_);
        tintedBlocks.put((Block)largeFern, Blocks.f_50360_);
        tintedBlocks.put((Block)sugarCane, Blocks.f_50130_);
        tintedBlocks.put((Block)tallGrass, Blocks.f_50359_);
        tintedBlocks.put((Block)vine, Blocks.f_50191_);
    }

    private FlowerPotBlock add(Block block, String name) {
        this.pottableBlocks.add(block);
        return VariantHandler.addFlowerPot(block, name, (Function<BlockBehaviour.Properties, BlockBehaviour.Properties>)Functions.identity());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        for (Block b : tintedBlocks.keySet()) {
            BlockState tState = tintedBlocks.get(b).m_49966_();
            BlockColor color = (state, worldIn, pos, tintIndex) -> Minecraft.m_91087_().m_91298_().m_92577_(tState, worldIn, pos, tintIndex);
            Minecraft.m_91087_().m_91298_().m_92589_(color, new Block[]{b});
        }
    }
}

