/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.client.module.VariantAnimalTexturesModule;
import vazkii.quark.content.mobs.module.CrabsModule;
import vazkii.quark.content.tools.module.SlimeInABucketModule;
import vazkii.quark.mixin.client.accessor.AccessorItemColors;

@LoadModule(category=ModuleCategory.CLIENT)
public class BucketsShowInhabitantsModule
extends QuarkModule {
    @Config
    public static boolean showAxolotls = true;
    @Config
    public static boolean showCrabs = true;
    @Config
    public static boolean showTropicalFish = true;
    @Config
    public static boolean showShinySlime = true;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.enqueue(() -> {
            ItemProperties.register((Item)Items.f_151057_, (ResourceLocation)new ResourceLocation("quark", "variant"), (ItemPropertyFunction)new MobBucketVariantProperty(Axolotl.Variant.f_149230_.length, () -> showAxolotls));
            ItemProperties.register((Item)CrabsModule.crab_bucket, (ResourceLocation)new ResourceLocation("quark", "variant"), (ItemPropertyFunction)new MobBucketVariantProperty(3, () -> showCrabs));
            ItemProperties.register((Item)SlimeInABucketModule.slime_in_a_bucket, (ResourceLocation)new ResourceLocation("quark", "shiny"), (ItemPropertyFunction)new ShinyMobBucketProperty(() -> showShinySlime && VariantAnimalTexturesModule.enabled() && VariantAnimalTexturesModule.enableShinySlime));
            ItemProperties.register((Item)Items.f_42459_, (ResourceLocation)new ResourceLocation("quark", "base"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(TropicalFish::m_30058_, () -> showTropicalFish));
            ItemProperties.register((Item)Items.f_42459_, (ResourceLocation)new ResourceLocation("quark", "pattern"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(TropicalFish::m_30064_, () -> showTropicalFish));
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        Holder.Reference tropicalBucket = ForgeRegistries.ITEMS.getDelegateOrThrow((Object)Items.f_42459_);
        ItemColor parent = ((AccessorItemColors)evt.getItemColors()).quark$getItemColors().get(tropicalBucket);
        evt.register((ItemColor)new TropicalFishBucketColor(parent, () -> showTropicalFish), new ItemLike[]{Items.f_42459_});
    }

    @OnlyIn(value=Dist.CLIENT)
    private class TropicalFishBucketColor
    implements ItemColor {
        @Nullable
        private final ItemColor parent;
        private final BooleanSupplier featureEnabled;

        public TropicalFishBucketColor(ItemColor parent, BooleanSupplier featureEnabled) {
            this.parent = parent;
            this.featureEnabled = featureEnabled;
        }

        public int m_92671_(@Nonnull ItemStack stack, int layer) {
            CompoundTag tag;
            if (BucketsShowInhabitantsModule.this.enabled && this.featureEnabled.getAsBoolean() && (layer == 1 || layer == 2) && (tag = stack.m_41783_()) != null && tag.m_128425_("BucketVariantTag", 3)) {
                int variant = tag.m_128451_("BucketVariantTag");
                DyeColor dyeColor = layer == 1 ? TropicalFish.m_30050_((int)variant) : TropicalFish.m_30052_((int)variant);
                float[] colorComponents = dyeColor.m_41068_();
                return (int)(colorComponents[0] * 255.0f) << 16 | (int)(colorComponents[1] * 255.0f) << 8 | (int)(colorComponents[2] * 255.0f);
            }
            return this.parent != null ? this.parent.m_92671_(stack, layer) : -1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class MobBucketVariantProperty
    implements ItemPropertyFunction {
        private final int maxVariants;
        private final BooleanSupplier featureEnabled;

        public MobBucketVariantProperty(int maxVariants, BooleanSupplier featureEnabled) {
            this.maxVariants = maxVariants;
            this.featureEnabled = featureEnabled;
        }

        public float m_141951_(@Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
            if (!BucketsShowInhabitantsModule.this.enabled || !this.featureEnabled.getAsBoolean()) {
                return 0.0f;
            }
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"Variant", (int)0) % this.maxVariants;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class ShinyMobBucketProperty
    implements ItemPropertyFunction {
        private final BooleanSupplier featureEnabled;

        public ShinyMobBucketProperty(BooleanSupplier featureEnabled) {
            this.featureEnabled = featureEnabled;
        }

        public float m_141951_(@Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
            UUID uuid;
            if (!BucketsShowInhabitantsModule.this.enabled || !this.featureEnabled.getAsBoolean()) {
                return 0.0f;
            }
            CompoundTag data = ItemNBTHelper.getCompound((ItemStack)stack, (String)"slime_nbt", (boolean)true);
            if (data != null && data.m_128403_("UUID") && VariantAnimalTexturesModule.isShiny(uuid = data.m_128342_("UUID"))) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class TropicalFishBucketVariantProperty
    implements ItemPropertyFunction {
        private final IntUnaryOperator extractor;
        private final BooleanSupplier featureEnabled;

        public TropicalFishBucketVariantProperty(IntUnaryOperator extractor, BooleanSupplier featureEnabled) {
            this.extractor = extractor;
            this.featureEnabled = featureEnabled;
        }

        public float m_141951_(@Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
            if (!BucketsShowInhabitantsModule.this.enabled || !this.featureEnabled.getAsBoolean()) {
                return 0.0f;
            }
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("BucketVariantTag", 3)) {
                int variant = tag.m_128451_("BucketVariantTag");
                return this.extractor.applyAsInt(variant) + 1;
            }
            return 0.0f;
        }
    }
}

