/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;

public class MapTooltips {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof MapItem) {
            List tooltip = event.getTooltipElements();
            if (!ImprovedTooltipsModule.mapRequireShift || Screen.m_96638_()) {
                tooltip.add(1, Either.right((Object)new MapComponent(stack)));
            } else if (ImprovedTooltipsModule.mapRequireShift && !Screen.m_96638_()) {
                tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.map_shift")));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record MapComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            Minecraft mc = Minecraft.m_91087_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)this.stack, (Level)mc.f_91073_);
            Integer mapID = MapItem.m_151131_((ItemStack)this.stack);
            if (mapdata == null) {
                return;
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)RES_MAP_BACKGROUND);
            int pad = 7;
            int size = 135 + pad;
            float scale = 0.5f;
            pose.m_85836_();
            pose.m_85837_((double)(tooltipX + 3), (double)(tooltipY + 3), 500.0);
            pose.m_85841_(scale, scale, 1.0f);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)pose, (int)(-pad), (int)(-pad), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            MultiBufferSource.BufferSource immediateBuffer = MultiBufferSource.m_109898_((BufferBuilder)buffer);
            mc.f_91063_.m_109151_().m_168771_(pose, (MultiBufferSource)immediateBuffer, mapID.intValue(), mapdata, true, 240);
            immediateBuffer.m_109911_();
            pose.m_85849_();
        }

        public int m_142103_() {
            Minecraft mc = Minecraft.m_91087_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)this.stack, (Level)mc.f_91073_);
            return mapdata != null ? 75 : 0;
        }

        public int m_142069_(@Nonnull Font font) {
            return 72;
        }
    }
}

