/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class VariantsConfig
extends AbstractConfigType {
    private static final VariantMap EMPTY_VARIANT_MAP = new VariantMap(new HashMap<String, Block>());
    @Config(description="The list of all variant types available for players to use. Values are treated as suffixes to block IDs for scanning.\nPrefix any variant type with ! to make it show up for Manual Variants but not be automatically scanned for. (e.g. '!polish')")
    private List<String> variantTypes = Arrays.asList("slab", "stairs", "wall", "fence", "fence_gate", "vertical_slab");
    @Config(description="By default, only a mod's namespace is scanned for variants for its items (e.g. if coolmod adds coolmod:fun_block, it'll search only for coolmod:fun_block_stairs).\n Mods in this list are also scanned for variants if none are found in itself (e.g. if quark is in the list and coolmod:fun_block_stairs doesn't exist, it'll try to look for quark:fun_block_stairs next)")
    private List<String> testedMods = Arrays.asList("quark");
    @Config
    private boolean printVariantMapToLog = false;
    @Config(description="Format is 'alias=original' in each value (e.g. 'wall=fence' means that a failed search for, minecraft:cobblestone_fence will try cobblestone_wall next)")
    private List<String> aliases = Arrays.asList("carpet=slab", "pane=fence");
    @Config(description="Ends of block IDs to try and remove when looking for variants. (e.g. minecraft:oak_planks goes into minecraft:oak_stairs, so we have to include '_planks' in this list for it to find them or else it'll only look for minecraft:oak_planks_stairs)")
    private List<String> stripCandidates = Arrays.asList("_planks", "_wool", "_block", "s");
    @Config(description="Add manual variant overrides here, the format is 'type,block,output' (e.g. polish,minecraft:stone_bricks,minecraft:chiseled_stone_bricks). The type must be listed in Variant Types")
    private List<String> manualVariants = new ArrayList<String>();
    @Config(description=" A list of block IDs and mappings to be excluded from variant selection.\nTo exclude a block from being turned into other blocks, just include the block ID (e.g. minecraft:cobblestone).\nTo exclude a block from having other blocks turned into it, suffix it with = (e.g. =minecraft:cobblestone_stairs)\nTo exclude a specific block->variant combination, put = between the two (e.g. minecraft:cobblestone=minecraft:cobblestone_stairs)")
    private List<String> blacklist = Arrays.asList("minecraft:snow", "minecraft:bamboo", "quark:bamboo_block");
    private Map<Block, VariantMap> blockVariants = new HashMap<Block, VariantMap>();
    private Map<Block, Block> originals = new HashMap<Block, Block>();
    private Multimap<String, String> aliasMap = HashMultimap.create();
    private Multimap<Block, ManualVariant> manualVariantMap = HashMultimap.create();
    private List<String> visibleVariants = new ArrayList<String>();
    private List<String> sortedSuffixes;

    @Override
    public void onReload(QuarkModule module, ConfigFlagManager flagManager) {
        String[] toks;
        this.blockVariants.clear();
        this.visibleVariants.clear();
        this.originals.clear();
        this.aliasMap.clear();
        this.manualVariantMap.clear();
        if (module != null && !module.enabled) {
            return;
        }
        for (String s : this.variantTypes) {
            this.visibleVariants.add(s.replaceAll("!", ""));
        }
        this.sortedSuffixes = new ArrayList<String>(this.visibleVariants);
        this.sortedSuffixes.sort((s1, s2) -> {
            int ct1 = s1.replaceAll("[^_]", "").length();
            int ct2 = s2.replaceAll("[^_]", "").length();
            return ct2 - ct1;
        });
        for (String s : this.aliases) {
            toks = s.split("=");
            this.aliasMap.put((Object)toks[1], (Object)toks[0]);
        }
        for (String s : this.manualVariants) {
            toks = s.split(",");
            Block block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(toks[1]));
            Block out = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(toks[2]));
            this.manualVariantMap.put((Object)block, (Object)new ManualVariant(toks[0], out));
        }
        Registry.f_122824_.forEach(this::getVariants);
        if (this.printVariantMapToLog) {
            this.logVariantMap();
        }
    }

    public String getVariantForBlock(Block block) {
        String name = Registry.f_122824_.m_7981_((Object)block).m_135815_();
        for (String suffix : this.sortedSuffixes) {
            if (name.endsWith(String.format("_%s", suffix))) {
                return suffix;
            }
            if (!this.aliasMap.containsKey((Object)suffix)) continue;
            for (String alias : this.aliasMap.get((Object)suffix)) {
                if (!name.endsWith(String.format("_%s", alias))) continue;
                return suffix;
            }
        }
        return null;
    }

    public Block getBlockForTarget(Block block, Block target) {
        return this.getBlockForVariant(block, this.getVariantForBlock(target));
    }

    public Block getBlockForVariant(Block block, String variant) {
        this.blockVariants.clear();
        if (variant == null || !this.sortedSuffixes.contains(variant)) {
            return block;
        }
        VariantMap map = this.getVariants(block);
        Block ret = map.variants.get(variant);
        if (ret != null) {
            return ret;
        }
        return block;
    }

    public Collection<Block> getAllVariants(Block block) {
        Map<String, Block> map = this.getVariants((Block)block).variants;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : this.variantTypes) {
            if (s.startsWith("!")) {
                s = s.substring(1);
            }
            if (!map.containsKey(s)) continue;
            blocks.add(map.get(s));
        }
        return blocks;
    }

    public Block getOriginalBlock(Block block) {
        return this.originals.getOrDefault(block, block);
    }

    public boolean isOriginal(Block block) {
        return this.originals.containsValue(block);
    }

    public boolean isVariant(Block block) {
        return this.originals.containsKey(block);
    }

    private VariantMap getVariants(Block block) {
        if (this.blockVariants.containsKey(block)) {
            return this.blockVariants.get(block);
        }
        HashMap<String, Block> newVariants = new HashMap<String, Block>();
        if (!this.isBlacklisted(block, null)) {
            for (String s : this.sortedSuffixes) {
                Block suffixed;
                if (!this.variantTypes.contains(s) || (suffixed = this.getSuffixedBlock(block, s)) == null || this.isBlacklisted(null, suffixed) || this.isBlacklisted(block, suffixed)) continue;
                newVariants.put(s, suffixed);
                this.originals.put(suffixed, block);
            }
        }
        if (this.manualVariantMap.containsKey((Object)block)) {
            for (ManualVariant mv : this.manualVariantMap.get((Object)block)) {
                newVariants.put(mv.type, mv.out);
                this.originals.put(mv.out, block);
            }
        }
        if (newVariants.isEmpty()) {
            this.blockVariants.put(block, EMPTY_VARIANT_MAP);
        } else {
            this.blockVariants.put(block, new VariantMap(newVariants));
        }
        return this.getVariants(block);
    }

    private Block getSuffixedBlock(Block ogBlock, String suffix) {
        String name;
        ResourceLocation resloc = Registry.f_122824_.m_7981_((Object)ogBlock);
        String namespace = resloc.m_135827_();
        Block ret = this.getSuffixedBlock(namespace, name = resloc.m_135815_(), suffix);
        if (ret != null) {
            return ret;
        }
        for (String mod : this.testedMods) {
            ret = this.getSuffixedBlock(mod, name, suffix);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Block getSuffixedBlock(String namespace, String name, String suffix) {
        for (String strip : this.stripCandidates) {
            String stripped;
            Block strippedAttempt;
            if (!name.endsWith(strip) || (strippedAttempt = this.getSuffixedBlock(namespace, stripped = name.substring(0, name.length() - strip.length()), suffix)) == null) continue;
            return strippedAttempt;
        }
        String targetStr = String.format("%s:%s_%s", namespace, name, suffix);
        ResourceLocation target = new ResourceLocation(targetStr);
        Block ret = (Block)Registry.f_122824_.m_7745_(target);
        if (ret == Blocks.f_50016_) {
            if (this.aliasMap.containsKey((Object)suffix)) {
                for (String alias : this.aliasMap.get((Object)suffix)) {
                    Block aliasAttempt = this.getSuffixedBlock(namespace, name, alias);
                    if (aliasAttempt == null) continue;
                    return aliasAttempt;
                }
            }
            return null;
        }
        return ret;
    }

    private boolean isBlacklisted(Block block, Block result) {
        if (this.blacklist.isEmpty()) {
            return false;
        }
        Object search = "";
        if (block != null) {
            search = (String)search + Registry.f_122824_.m_7981_((Object)block).toString();
        }
        if (result != null) {
            search = (String)search + "=" + Registry.f_122824_.m_7981_((Object)result).toString();
        }
        return !((String)search).isEmpty() && this.blacklist.contains(search);
    }

    public boolean isKnownVariant(String variant) {
        return this.visibleVariants.contains(variant);
    }

    public List<String> getVisibleVariants() {
        return this.visibleVariants;
    }

    private void logVariantMap() {
        for (Map.Entry<Block, Block> entry : this.originals.entrySet()) {
            Quark.LOG.info("{} is variant of {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private record ManualVariant(String type, Block out) {
    }

    private record VariantMap(Map<String, Block> variants) {
        private boolean isEmpty() {
            return this.variants.isEmpty();
        }
    }
}

