/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class DataExport {
    @HideFromJS
    public static DataExport export = null;
    public CommandSourceStack source;
    private final Map<String, Callable<byte[]>> exportedFiles = new ConcurrentHashMap<String, Callable<byte[]>>();

    public static void exportData() {
        if (export != null) {
            try {
                export.exportData0();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            export = null;
        }
    }

    private static <T> void addRegistry(JsonObject o, String name, Registrar<T> r) {
        JsonArray a = new JsonArray();
        for (ResourceLocation id : r.getIds()) {
            a.add(id.toString());
        }
        o.add(name, (JsonElement)a);
    }

    public void add(String path, Callable<byte[]> data) {
        try {
            this.exportedFiles.put(path, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addString(String path, String data) {
        this.add(path, () -> data.getBytes(StandardCharsets.UTF_8));
    }

    public void addJson(String path, JsonElement json) {
        this.add(path, () -> JsonUtils.toPrettyString((JsonElement)json).getBytes(StandardCharsets.UTF_8));
    }

    private void exportData0() throws Exception {
        for (Object regKey : Registry.f_122897_.m_214010_()) {
            Registrar reg = KubeJSRegistries.REGISTRIES.get((ResourceKey)regKey);
            if (reg == null) continue;
            ArrayList<Pair> regItems = new ArrayList<Pair>();
            for (Object e2 : reg.entrySet()) {
                Map.Entry entry = (Map.Entry)e2;
                regItems.add(Pair.of((Object)((ResourceKey)entry.getKey()).m_135782_().toString(), (Object)(entry.getValue() == null ? "null" : entry.getValue().getClass().getName())));
            }
            regItems.sort((o1, o2) -> ((String)o1.getLeft()).compareToIgnoreCase((String)o2.getLeft()));
            JsonObject j = new JsonObject();
            for (Pair pair : regItems) {
                j.addProperty((String)pair.getLeft(), (String)pair.getRight());
            }
            this.addJson("registries/" + regKey.m_135782_().m_135815_() + ".json", (JsonElement)j);
        }
        this.addString("errors.log", String.join((CharSequence)"\n", ScriptType.SERVER.errors));
        this.addString("warnings.log", String.join((CharSequence)"\n", ScriptType.SERVER.warnings));
        JsonArray modArr = new JsonArray();
        for (Mod mod : Platform.getMods()) {
            JsonObject o = new JsonObject();
            o.addProperty("id", mod.getModId().trim());
            o.addProperty("name", mod.getName().trim());
            o.addProperty("version", mod.getVersion().trim());
            o.addProperty("description", mod.getDescription().trim());
            o.addProperty("authors", String.join((CharSequence)", ", mod.getAuthors()).trim());
            o.addProperty("homepage", mod.getHomepage().orElse("").trim());
            o.addProperty("sources", mod.getSources().orElse("").trim());
            o.addProperty("issue_tracker", mod.getIssueTracker().orElse("").trim());
            o.addProperty("license", mod.getLicense() == null ? "" : String.join((CharSequence)", ", mod.getLicense()).trim());
            o.entrySet().removeIf(e -> {
                JsonPrimitive p;
                Object patt3907$temp = e.getValue();
                return patt3907$temp instanceof JsonPrimitive && (p = (JsonPrimitive)patt3907$temp).isString() && p.getAsString().isEmpty();
            });
            modArr.add((JsonElement)o);
        }
        this.addJson("mods.json", (JsonElement)modArr);
        KubeJSPlugins.forEachPlugin(p -> p.exportServerData(this));
        JsonArray index = new JsonArray();
        this.exportedFiles.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(arg_0 -> ((JsonArray)index).add(arg_0));
        this.addJson("index.json", (JsonElement)index);
        Files.walk(KubeJSPaths.EXPORT, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        Files.createDirectory(KubeJSPaths.EXPORT, new FileAttribute[0]);
        CompletableFuture[] arr = new CompletableFuture[this.exportedFiles.size()];
        int i = 0;
        for (Map.Entry entry : this.exportedFiles.entrySet()) {
            arr[i++] = CompletableFuture.runAsync(() -> {
                try {
                    Path path = KubeJSPaths.EXPORT.resolve(((String)entry.getKey()).replace(':', '/'));
                    Path parent = path.getParent();
                    if (Files.notExists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        Files.createFile(path, new FileAttribute[0]);
                    }
                    Files.write(path, (byte[])((Callable)entry.getValue()).call(), new OpenOption[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }, Util.m_183992_());
        }
        CompletableFuture.allOf(arr).join();
        if (this.source.m_81377_().m_129792_()) {
            this.source.m_81354_((Component)Component.m_237113_((String)"Done! Export in local/kubejs/export").kjs$clickOpenFile(KubeJSPaths.EXPORT.toAbsolutePath().toString()), false);
        } else {
            this.source.m_81354_((Component)Component.m_237113_((String)"Done! Export in local/kubejs/export"), false);
        }
    }
}

