/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class DimensionTitleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimensiontitle").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> DimensionTitleCommand.displayTitle((CommandSourceStack)ctx.getSource(), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension")))));
    }

    public static int displayTitle(CommandSourceStack commandSource, ServerLevel world) {
        ResourceLocation dimensionBaseKey = world.m_46472_().m_135782_();
        String dimensionNameKey = Util.m_137492_((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
        if (TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist.contains(dimensionBaseKey.toString())) {
            commandSource.m_81354_((Component)Component.m_237113_((String)"That dimension is blacklisted, so its title won't normally show!"), false);
        }
        MutableComponent dimensionTitle = Language.m_128107_().m_6722_(dimensionNameKey) ? Component.m_237115_((String)dimensionNameKey) : Component.m_237113_((String)"???");
        String dimensionColorKey = dimensionNameKey + ".color";
        String dimensionColorStr = Language.m_128107_().m_6722_(dimensionColorKey) ? Language.m_128107_().m_6834_(dimensionColorKey) : TravelersTitlesCommon.titleManager.dimensionTitleRenderer.titleDefaultTextColor;
        TravelersTitlesCommon.titleManager.dimensionTitleRenderer.setColor(dimensionColorStr);
        TravelersTitlesCommon.titleManager.dimensionTitleRenderer.displayTitle((Component)dimensionTitle, null);
        return 1;
    }
}

