/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Utils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseReusableItem
extends BaseItem {
    private final boolean damage;
    private final boolean tooltip;

    public BaseReusableItem(Function<Item.Properties, Item.Properties> properties) {
        this(true, properties);
    }

    public BaseReusableItem(boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        this(0, tooltip, properties);
    }

    public BaseReusableItem(int uses, Function<Item.Properties, Item.Properties> properties) {
        this(uses, true, properties);
    }

    public BaseReusableItem(int uses, boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.m_41499_(Math.max(uses - 1, 0)).setNoRepair()));
        this.damage = uses > 0;
        this.tooltip = tooltip;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        if (!this.damage) {
            return copy;
        }
        int unbreaking = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        for (int i = 0; i < unbreaking; ++i) {
            if (!DigDurabilityEnchantment.m_220282_((ItemStack)stack, (int)unbreaking, (RandomSource)Utils.RANDOM)) continue;
            return copy;
        }
        copy.m_41721_(stack.m_41773_() + 1);
        if (copy.m_41773_() > stack.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return copy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag advanced) {
        if (this.tooltip) {
            if (this.damage) {
                int damage = stack.m_41776_() - stack.m_41773_() + 1;
                if (damage == 1) {
                    tooltip.add((Component)Tooltips.ONE_USE_LEFT.build());
                } else {
                    tooltip.add((Component)Tooltips.USES_LEFT.args(damage).build());
                }
            } else {
                tooltip.add((Component)Tooltips.UNLIMITED_USES.build());
            }
        }
    }
}

