/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpendMediaTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("hexcasting", "spend_media");
    private static final String TAG_MEDIA_SPENT = "media_spent";
    private static final String TAG_MEDIA_WASTED = "media_wasted";

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext pContext) {
        return new Instance(predicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_MEDIA_SPENT)), MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_MEDIA_WASTED)));
    }

    public void trigger(ServerPlayer player, int mediaSpent, int mediaWasted) {
        super.m_66234_(player, inst -> inst.test(mediaSpent, mediaWasted));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints mediaSpent;
        protected final MinMaxBounds.Ints mediaWasted;

        public Instance(EntityPredicate.Composite predicate, MinMaxBounds.Ints mediaSpent, MinMaxBounds.Ints mediaWasted) {
            super(ID, predicate);
            this.mediaSpent = mediaSpent;
            this.mediaWasted = mediaWasted;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject json = super.m_7683_(ctx);
            if (!this.mediaSpent.m_55327_()) {
                json.add(SpendMediaTrigger.TAG_MEDIA_SPENT, this.mediaSpent.m_55328_());
            }
            if (!this.mediaWasted.m_55327_()) {
                json.add(SpendMediaTrigger.TAG_MEDIA_WASTED, this.mediaWasted.m_55328_());
            }
            return json;
        }

        private boolean test(int mediaSpentIn, int mediaWastedIn) {
            return this.mediaSpent.m_55390_(mediaSpentIn) && this.mediaWasted.m_55390_(mediaWastedIn);
        }
    }
}

