/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.iota;

import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIota
extends Iota {
    public static IotaType<ListIota> TYPE = new IotaType<ListIota>(){

        @Override
        @Nullable
        public ListIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            ListTag listTag = (ListTag)HexUtils.downcast(tag, ListTag.f_128714_);
            ArrayList<Iota> out = new ArrayList<Iota>(listTag.size());
            for (Tag sub : listTag) {
                CompoundTag csub = (CompoundTag)HexUtils.downcast(sub, CompoundTag.f_128326_);
                Iota subiota = HexIotaTypes.deserialize(csub, world);
                if (subiota == null) {
                    return null;
                }
                out.add(subiota);
            }
            return new ListIota(out);
        }

        @Override
        public Component display(Tag tag) {
            MutableComponent out = Component.m_237119_();
            ListTag list = (ListTag)HexUtils.downcast(tag, ListTag.f_128714_);
            for (int i = 0; i < list.size(); ++i) {
                Tag sub = list.get(i);
                CompoundTag csub = (CompoundTag)HexUtils.downcast(sub, CompoundTag.f_128326_);
                out.m_7220_(HexIotaTypes.getDisplay(csub));
                if (i >= list.size() - 1) continue;
                out.m_130946_(", ");
            }
            return Component.m_237110_((String)"hexcasting.tooltip.list_contents", (Object[])new Object[]{out}).m_130940_(ChatFormatting.DARK_PURPLE);
        }

        @Override
        public int color() {
            return -5635926;
        }
    };

    public ListIota(@NotNull SpellList list) {
        super(HexIotaTypes.LIST, list);
    }

    public ListIota(@NotNull List<Iota> list) {
        this(new SpellList.LList(list));
    }

    public SpellList getList() {
        return (SpellList)this.payload;
    }

    @Override
    public boolean isTruthy() {
        return this.getList().getNonEmpty();
    }

    @Override
    public boolean toleratesOther(Iota that) {
        Iota y;
        Iota x;
        if (!ListIota.typesMatch(this, that)) {
            return false;
        }
        SpellList a = this.getList();
        if (!(that instanceof ListIota)) {
            return false;
        }
        ListIota list = (ListIota)that;
        SpellList b = list.getList();
        SpellList.SpellListIterator aIter = a.iterator();
        SpellList.SpellListIterator bIter = b.iterator();
        do {
            if (!aIter.hasNext() && !bIter.hasNext()) {
                return true;
            }
            if (aIter.hasNext() == bIter.hasNext()) continue;
            return false;
        } while (Iota.tolerates(x = aIter.next(), y = bIter.next()));
        return false;
    }

    @Override
    @NotNull
    public Tag serialize() {
        ListTag out = new ListTag();
        for (Iota subdatum : this.getList()) {
            out.add((Object)HexIotaTypes.serialize(subdatum));
        }
        return out;
    }
}

