/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.be.BlockEntityAkashicBookshelfRenderer;
import at.petrak.hexcasting.client.be.BlockEntitySlateRenderer;
import at.petrak.hexcasting.client.entity.WallScrollRenderer;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public class RegisterClientStuff {
    public static void init() {
        RegisterClientStuff.registerDataHolderOverrides(HexItems.FOCUS, stack -> HexItems.FOCUS.readIotaTag((ItemStack)stack) != null, ItemFocus::isSealed);
        RegisterClientStuff.registerDataHolderOverrides(HexItems.SPELLBOOK, stack -> HexItems.SPELLBOOK.readIotaTag((ItemStack)stack) != null, ItemSpellbook::isSealed);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.CYPHER);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.TRINKET);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.ARTIFACT);
        IClientXplatAbstractions x = IClientXplatAbstractions.INSTANCE;
        x.registerItemProperty(HexItems.BATTERY, ItemMediaBattery.MEDIA_PREDICATE, (stack, level, holder, holderID) -> {
            MediaHolderItem item = (MediaHolderItem)stack.m_41720_();
            return item.getMediaFullness(stack);
        });
        x.registerItemProperty(HexItems.BATTERY, ItemMediaBattery.MAX_MEDIA_PREDICATE, (stack, level, holder, holderID) -> {
            ItemMediaBattery item = (ItemMediaBattery)stack.m_41720_();
            int max = item.getMaxMedia(stack);
            return (float)Math.sqrt((float)max / 100000.0f / 10.0f);
        });
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_SMOL);
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_MEDIUM);
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_LARGE);
        x.registerItemProperty((Item)HexItems.SLATE, ItemSlate.WRITTEN_PRED, (stack, level, holder, holderID) -> ItemSlate.hasPattern(stack) ? 1.0f : 0.0f);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_BIRCH);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_SPRUCE);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_JUNGLE);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_DARK_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_ACACIA);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_EDIFIED);
        x.setRenderLayer(HexBlocks.CONJURED_LIGHT, RenderType.m_110463_());
        x.setRenderLayer(HexBlocks.CONJURED_BLOCK, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.EDIFIED_DOOR, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.EDIFIED_TRAPDOOR, RenderType.m_110463_());
        x.setRenderLayer(HexBlocks.AKASHIC_BOOKSHELF, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.SCONCE, RenderType.m_110463_());
        x.setRenderLayer((Block)HexBlocks.AMETHYST_EDIFIED_LEAVES, RenderType.m_110457_());
        x.setRenderLayer((Block)HexBlocks.AVENTURINE_EDIFIED_LEAVES, RenderType.m_110457_());
        x.setRenderLayer((Block)HexBlocks.CITRINE_EDIFIED_LEAVES, RenderType.m_110457_());
        x.setRenderLayer(HexBlocks.AKASHIC_RECORD, RenderType.m_110466_());
        x.registerEntityRenderer(HexEntities.WALL_SCROLL, WallScrollRenderer::new);
        RegisterClientStuff.addScryingLensStuff();
    }

    public static void registerColorProviders(BiConsumer<ItemColor, Item> itemColorRegistry, BiConsumer<BlockColor, Block> blockColorRegistry) {
        itemColorRegistry.accept(RegisterClientStuff.makeIotaStorageColorizer(HexItems.FOCUS::getColor), HexItems.FOCUS);
        itemColorRegistry.accept(RegisterClientStuff.makeIotaStorageColorizer(HexItems.SPELLBOOK::getColor), HexItems.SPELLBOOK);
        blockColorRegistry.accept((bs, level, pos, idx) -> {
            if (!((Boolean)bs.m_61143_((Property)BlockAkashicBookshelf.HAS_BOOKS)).booleanValue() || level == null || pos == null) {
                return -1;
            }
            BlockEntity tile = level.m_7702_(pos);
            if (!(tile instanceof BlockEntityAkashicBookshelf)) {
                return -1;
            }
            BlockEntityAkashicBookshelf beas = (BlockEntityAkashicBookshelf)tile;
            CompoundTag iotaTag = beas.getIotaTag();
            if (iotaTag == null) {
                return -1;
            }
            return HexIotaTypes.getColor(iotaTag);
        }, HexBlocks.AKASHIC_BOOKSHELF);
    }

    public static ItemColor makeIotaStorageColorizer(ToIntFunction<ItemStack> getColor) {
        return (stack, idx) -> {
            if (idx == 1) {
                return getColor.applyAsInt(stack);
            }
            return -1;
        };
    }

    private static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60734_() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt7733$temp = world.m_7702_(pos);
            if (patt7733$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt7733$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50065_, (lines, state, pos, observer, world, direction) -> {
            int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            float rCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, Mth.m_14031_((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | Mth.m_14159_((float)rCol, (float)gCol, (float)bCol);
            NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42703_), (Object)Component.m_237113_((String)String.valueOf(instrument.ordinal())).m_130938_(RegisterClientStuff.color(RegisterClientStuff.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41859_), (Object)Component.m_237113_((String)String.valueOf(note)).m_130938_(RegisterClientStuff.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction) -> {
            BlockEntityAkashicBookshelf tile;
            CompoundTag iotaTag;
            BlockEntity patt9236$temp = world.m_7702_(pos);
            if (patt9236$temp instanceof BlockEntityAkashicBookshelf && (iotaTag = (tile = (BlockEntityAkashicBookshelf)patt9236$temp).getIotaTag()) != null) {
                Component display = HexIotaTypes.getDisplay(iotaTag);
                lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42517_), (Object)display));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50328_, (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(true);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)Component.m_237113_((String)(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))).m_130938_(RegisterClientStuff.redstoneColor(comparatorValue))));
            boolean compare = state.m_61143_((Property)ComparatorBlock.f_51854_) == ComparatorMode.COMPARE;
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41978_), (Object)Component.m_237113_((String)(compare ? ">=" : "-")).m_130938_(RegisterClientStuff.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50030_, (lines, state, pos, observer, world, direction) -> {
            int power = RegisterClientStuff.getPoweredRailStrength(world, pos, state);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41860_), (Object)Component.m_237113_((String)String.valueOf(power)).m_130938_(RegisterClientStuff.redstoneColor(power, 9))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.f_50146_, (lines, state, pos, observer, world, direction) -> lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42524_), (Object)Component.m_237113_((String)String.valueOf(state.m_61143_((Property)RepeaterBlock.f_55798_))).m_130940_(ChatFormatting.YELLOW))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60734_() instanceof BeehiveBlock, (lines, state, pos, observer, world, direction) -> {
            int count = ScryingLensOverlayRegistry.getBeeValue();
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42785_), (Object)(count == -1 ? Component.m_237119_() : Component.m_237110_((String)("hexcasting.tooltip.lens.bee" + (count == 1 ? ".single" : "")), (Object[])new Object[]{count}))));
        });
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60803_() && !state.m_60713_(Blocks.f_50328_), (lines, state, pos, observer, world, direction) -> {
            int signalStrength = 0;
            if (state.m_60734_() instanceof RedStoneWireBlock) {
                signalStrength = (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
            } else {
                for (Direction dir : Direction.values()) {
                    signalStrength = Math.max(signalStrength, state.m_60746_((BlockGetter)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new ItemStack((ItemLike)Items.f_42451_), (Object)Component.m_237113_((String)String.valueOf(signalStrength)).m_130938_(RegisterClientStuff.redstoneColor(signalStrength))));
        });
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.m_60807_(), (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = ScryingLensOverlayRegistry.getComparatorValue(false);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_42351_), (Object)Component.m_237113_((String)(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))).m_130938_(RegisterClientStuff.redstoneColor(comparatorValue))));
        });
    }

    private static UnaryOperator<Style> color(int color) {
        return style -> style.m_131148_(TextColor.m_131266_((int)color));
    }

    private static UnaryOperator<Style> redstoneColor(int power) {
        return RegisterClientStuff.redstoneColor(power, 15);
    }

    private static UnaryOperator<Style> redstoneColor(int power, int max) {
        return RegisterClientStuff.color(RedStoneWireBlock.m_55606_((int)Mth.m_14045_((int)(power * max / 15), (int)0, (int)15)));
    }

    private static int instrumentColor(NoteBlockInstrument instrument) {
        return switch (instrument) {
            case NoteBlockInstrument.BASEDRUM -> MaterialColor.f_76409_.f_76396_;
            case NoteBlockInstrument.SNARE, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.PLING -> MaterialColor.f_76400_.f_76396_;
            case NoteBlockInstrument.HAT -> MaterialColor.f_76412_.f_76396_;
            case NoteBlockInstrument.BASS -> MaterialColor.f_76411_.f_76396_;
            case NoteBlockInstrument.FLUTE -> MaterialColor.f_76407_.f_76396_;
            case NoteBlockInstrument.BELL -> MaterialColor.f_76366_.f_76396_;
            case NoteBlockInstrument.GUITAR -> MaterialColor.f_76401_.f_76396_;
            case NoteBlockInstrument.CHIME -> MaterialColor.f_76403_.f_76396_;
            case NoteBlockInstrument.IRON_XYLOPHONE -> MaterialColor.f_76404_.f_76396_;
            case NoteBlockInstrument.COW_BELL -> MaterialColor.f_76362_.f_76396_;
            case NoteBlockInstrument.DIDGERIDOO -> MaterialColor.f_76413_.f_76396_;
            case NoteBlockInstrument.BIT -> MaterialColor.f_76369_.f_76396_;
            case NoteBlockInstrument.BANJO -> MaterialColor.f_76416_.f_76396_;
            default -> -1;
        };
    }

    private static void registerDataHolderOverrides(IotaHolderItem item, Predicate<ItemStack> hasIota, Predicate<ItemStack> isSealed) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((Item)item, ItemFocus.OVERLAY_PRED, (stack, level, holder, holderID) -> {
            if (!hasIota.test(stack) && !NBTHelper.hasString(stack, "VisualOverride")) {
                return 0.0f;
            }
            if (!isSealed.test(stack)) {
                return 1.0f;
            }
            return 2.0f;
        });
    }

    private static int getPoweredRailStrength(Level level, BlockPos pos, BlockState state) {
        if (level.m_46753_(pos)) {
            return 9;
        }
        int positiveValue = RegisterClientStuff.findPoweredRailSignal(level, pos, state, true, 0);
        int negativeValue = RegisterClientStuff.findPoweredRailSignal(level, pos, state, false, 0);
        return Math.max(positiveValue, negativeValue);
    }

    private static int findPoweredRailSignal(Level level, BlockPos pos, BlockState state, boolean travelPositive, int depth) {
        if (depth >= 8) {
            return 0;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        boolean descending = true;
        RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
        switch (shape) {
            case NORTH_SOUTH: {
                if (travelPositive) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case EAST_WEST: {
                if (travelPositive) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case ASCENDING_EAST: {
                if (travelPositive) {
                    --x;
                } else {
                    ++x;
                    ++y;
                    descending = false;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (travelPositive) {
                    --x;
                    ++y;
                    descending = false;
                } else {
                    ++x;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (travelPositive) {
                    ++z;
                } else {
                    --z;
                    ++y;
                    descending = false;
                }
                shape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (travelPositive) {
                    ++z;
                    ++y;
                    descending = false;
                } else {
                    --z;
                }
                shape = RailShape.NORTH_SOUTH;
            }
        }
        int power = RegisterClientStuff.getPowerFromRail(level, new BlockPos(x, y, z), travelPositive, depth, shape);
        if (power > 0) {
            return power;
        }
        if (descending) {
            return RegisterClientStuff.getPowerFromRail(level, new BlockPos(x, y - 1, z), travelPositive, depth, shape);
        }
        return 0;
    }

    private static int getPowerFromRail(Level level, BlockPos pos, boolean travelPositive, int depth, RailShape shape) {
        BlockState otherState = level.m_8055_(pos);
        if (!otherState.m_60713_(Blocks.f_50030_)) {
            return 0;
        }
        RailShape otherShape = (RailShape)otherState.m_61143_((Property)PoweredRailBlock.f_55214_);
        if (shape == RailShape.EAST_WEST && (otherShape == RailShape.NORTH_SOUTH || otherShape == RailShape.ASCENDING_NORTH || otherShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (otherShape == RailShape.EAST_WEST || otherShape == RailShape.ASCENDING_EAST || otherShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        if (((Boolean)otherState.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            return level.m_46753_(pos) ? 8 - depth : RegisterClientStuff.findPoweredRailSignal(level, pos, otherState, travelPositive, depth + 1);
        }
        return 0;
    }

    private static void registerScrollOverrides(ItemScroll scroll) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(scroll, ItemScroll.ANCIENT_PREDICATE, (stack, level, holder, holderID) -> NBTHelper.hasString(stack, "op_id") ? 1.0f : 0.0f);
    }

    private static void registerPackagedSpellOverrides(ItemPackagedHex item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemPackagedHex.HAS_PATTERNS_PRED, (stack, level, holder, holderID) -> item.hasHex(stack) ? 1.0f : 0.0f);
    }

    private static void registerWandOverrides(ItemStaff item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemStaff.FUNNY_LEVEL_PREDICATE, (stack, level, holder, holderID) -> {
            if (!stack.m_41788_()) {
                return 0.0f;
            }
            String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT);
            if (name.contains("old")) {
                return 1.0f;
            }
            if (name.contains("wand of the forest")) {
                return 2.0f;
            }
            return 0.0f;
        });
    }

    public static void registerBlockEntityRenderers(@NotNull BlockEntityRendererRegisterererer registerer) {
        registerer.registerBlockEntityRenderer(HexBlockEntities.SLATE_TILE, BlockEntitySlateRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, BlockEntityAkashicBookshelfRenderer::new);
    }

    @FunctionalInterface
    public static interface BlockEntityRendererRegisterererer {
        public <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<T> var1, BlockEntityRendererProvider<? super T> var2);
    }
}

