/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellAction;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.common.network.MsgBeepAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBeep;", "Lat/petrak/hexcasting/api/spell/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hasCastingSound", "", "Spell", "hexcasting-forge-1.19.2"})
public final class OpBeep
implements SpellAction {
    @NotNull
    public static final OpBeep INSTANCE = new OpBeep();
    private static final int argc = 3;

    private OpBeep() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends Iota> args, @NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec3 target = OperatorUtils.getVec3(args, 0, this.getArgc());
        int instrument = OperatorUtils.getPositiveIntUnder(args, 1, NoteBlockInstrument.values().length, this.getArgc());
        int note = OperatorUtils.getPositiveIntUnderInclusive(args, 2, 24, this.getArgc());
        ctx.assertVecInRange(target);
        return new Triple((Object)new Spell(target, note, NoteBlockInstrument.values()[instrument]), (Object)1000, (Object)CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, target, 1.0, 0, 4, null)));
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return false;
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.operate(this, continuation, stack, ravenmind, ctx);
    }

    @Override
    public boolean isGreat() {
        return SpellAction.DefaultImpls.isGreat(this);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellAction.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellAction.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellAction.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBeep$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "target", "Lnet/minecraft/world/phys/Vec3;", "note", "", "instrument", "Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "(Lnet/minecraft/world/phys/Vec3;ILnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;)V", "getInstrument", "()Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "getNote", "()I", "getTarget", "()Lnet/minecraft/world/phys/Vec3;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "hexcasting-forge-1.19.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Vec3 target;
        private final int note;
        @NotNull
        private final NoteBlockInstrument instrument;

        public Spell(@NotNull Vec3 target, int note, @NotNull NoteBlockInstrument instrument) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
            this.target = target;
            this.note = note;
            this.instrument = instrument;
        }

        @NotNull
        public final Vec3 getTarget() {
            return this.target;
        }

        public final int getNote() {
            return this.note;
        }

        @NotNull
        public final NoteBlockInstrument getInstrument() {
            return this.instrument;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            IXplatAbstractions.INSTANCE.sendPacketNear(this.target, 128.0, ctx.getWorld(), new MsgBeepAck(this.target, this.note, this.instrument));
            ctx.getWorld().m_220400_(null, GameEvent.f_223699_, this.target);
        }

        @NotNull
        public final Vec3 component1() {
            return this.target;
        }

        public final int component2() {
            return this.note;
        }

        @NotNull
        public final NoteBlockInstrument component3() {
            return this.instrument;
        }

        @NotNull
        public final Spell copy(@NotNull Vec3 target, int note, @NotNull NoteBlockInstrument instrument) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
            return new Spell(target, note, instrument);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Vec3 vec3, int n, NoteBlockInstrument noteBlockInstrument, int n2, Object object) {
            if ((n2 & 1) != 0) {
                vec3 = spell.target;
            }
            if ((n2 & 2) != 0) {
                n = spell.note;
            }
            if ((n2 & 4) != 0) {
                noteBlockInstrument = spell.instrument;
            }
            return spell.copy(vec3, n, noteBlockInstrument);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ", note=" + this.note + ", instrument=" + this.instrument + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + Integer.hashCode(this.note);
            result = result * 31 + this.instrument.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            if (this.note != spell.note) {
                return false;
            }
            return this.instrument == spell.instrument;
        }
    }
}

