/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPackagedHex
extends ItemMediaHolder
implements HexHolderItem {
    public static final String TAG_PROGRAM = "patterns";
    public static final ResourceLocation HAS_PATTERNS_PRED = HexAPI.modLoc("has_patterns");

    public ItemPackagedHex(Item.Properties pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    @Override
    public boolean canRecharge(ItemStack stack) {
        return !this.breakAfterDepletion();
    }

    @Override
    public boolean canProvideMedia(ItemStack stack) {
        return false;
    }

    @Override
    public boolean hasHex(ItemStack stack) {
        return NBTHelper.hasList(stack, TAG_PROGRAM, (byte)10);
    }

    @Override
    @Nullable
    public List<Iota> getHex(ItemStack stack, ServerLevel level) {
        ListTag patsTag = NBTHelper.getList(stack, TAG_PROGRAM, 10);
        if (patsTag == null) {
            return null;
        }
        ArrayList<Iota> out = new ArrayList<Iota>();
        for (Tag patTag : patsTag) {
            CompoundTag tag = NBTHelper.getAsCompound(patTag);
            out.add(HexIotaTypes.deserialize(tag, level));
        }
        return out;
    }

    @Override
    public void writeHex(ItemStack stack, List<Iota> program, int media) {
        ListTag patsTag = new ListTag();
        for (Iota pat : program) {
            patsTag.add((Object)HexIotaTypes.serialize(pat));
        }
        NBTHelper.putList(stack, TAG_PROGRAM, patsTag);
        ItemPackagedHex.withMedia(stack, media, media);
    }

    @Override
    public void clearHex(ItemStack stack) {
        NBTHelper.remove(stack, TAG_PROGRAM);
        NBTHelper.remove(stack, "hexcasting:media");
        NBTHelper.remove(stack, "hexcasting:start_media");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!this.hasHex(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (world.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        List<Iota> instrs = this.getHex(stack, (ServerLevel)world);
        if (instrs == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        CastingContext ctx = new CastingContext(sPlayer, usedHand, CastingContext.CastSource.PACKAGED_HEX);
        CastingHarness harness = new CastingHarness(ctx);
        ControllerInfo info = harness.executeIotas(instrs, sPlayer.m_9236_());
        boolean broken = this.breakAfterDepletion() && this.getMedia(stack) == 0;
        Stat stat = broken ? Stats.f_12983_.m_12902_((Object)this) : Stats.f_12982_.m_12902_((Object)this);
        player.m_36246_(stat);
        sPlayer.m_36335_().m_41524_((Item)this, 5);
        if (broken) {
            stack.m_41774_(1);
            player.m_21190_(usedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int m_8105_(ItemStack pStack) {
        return 16;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }
}

