/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.SealFocusRecipe;
import at.petrak.hexcasting.common.recipe.SealSpellbookRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class HexRecipeStuffRegistry {
    private static final Map<ResourceLocation, RecipeSerializer<?>> SERIALIZERS = new LinkedHashMap();
    private static final Map<ResourceLocation, RecipeType<?>> TYPES = new LinkedHashMap();
    public static final RecipeSerializer<?> BRAINSWEEP = HexRecipeStuffRegistry.registerSerializer("brainsweep", new BrainsweepRecipe.Serializer());
    public static final RecipeSerializer<SealFocusRecipe> SEAL_FOCUS = HexRecipeStuffRegistry.registerSerializer("seal_focus", SealFocusRecipe.SERIALIZER);
    public static final RecipeSerializer<SealSpellbookRecipe> SEAL_SPELLBOOK = HexRecipeStuffRegistry.registerSerializer("seal_spellbook", SealSpellbookRecipe.SERIALIZER);
    public static RecipeType<BrainsweepRecipe> BRAINSWEEP_TYPE = HexRecipeStuffRegistry.registerType("brainsweep");

    public static void registerSerializers(BiConsumer<RecipeSerializer<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, RecipeSerializer<?>> e : SERIALIZERS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerTypes(BiConsumer<RecipeType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, RecipeType<?>> e : TYPES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends Recipe<?>> RecipeSerializer<T> registerSerializer(String name, RecipeSerializer<T> rs) {
        RecipeSerializer<T> old = SERIALIZERS.put(HexAPI.modLoc(name), rs);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return rs;
    }

    private static <T extends Recipe<?>> RecipeType<T> registerType(final String name) {
        RecipeType type = new RecipeType<T>(){

            public String toString() {
                return "hexcasting:" + name;
            }
        };
        TYPES.put(HexAPI.modLoc(name), type);
        return type;
    }
}

