/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.common.blocks.behavior.HexComposting;
import at.petrak.hexcasting.common.blocks.behavior.HexStrippables;
import at.petrak.hexcasting.common.casting.RegisterPatterns;
import at.petrak.hexcasting.common.casting.operators.spells.great.OpFlight;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.items.ItemLens;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexCommands;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexLootFunctions;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.common.misc.AkashicTreeGrower;
import at.petrak.hexcasting.common.misc.Brainsweeping;
import at.petrak.hexcasting.common.misc.PlayerPositionRecorder;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import at.petrak.hexcasting.forge.ForgeHexArgumentTypeRegistry;
import at.petrak.hexcasting.forge.ForgeHexClientInitializer;
import at.petrak.hexcasting.forge.ForgeHexConfig;
import at.petrak.hexcasting.forge.cap.CapSyncers;
import at.petrak.hexcasting.forge.cap.ForgeCapabilityHandler;
import at.petrak.hexcasting.forge.datagen.HexForgeDataGenerators;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.forge.interop.curios.CuriosRenderers;
import at.petrak.hexcasting.forge.network.ForgePacketHandler;
import at.petrak.hexcasting.forge.network.MsgBrainsweepAck;
import at.petrak.hexcasting.forge.recipe.ForgeModConditionalIngredient;
import at.petrak.hexcasting.forge.recipe.ForgeUnsealedIngredient;
import at.petrak.hexcasting.interop.HexInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hexcasting")
public class ForgeHexInitializer {
    public ForgeHexInitializer() {
        ForgeHexInitializer.initConfig();
        ForgeHexInitializer.initRegistry();
        ForgeHexInitializer.initListeners();
    }

    private static void initConfig() {
        Pair config = new ForgeConfigSpec.Builder().configure(ForgeHexConfig::new);
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Client::new);
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Server::new);
        HexConfig.setCommon((HexConfig.CommonConfigAccess)config.getLeft());
        HexConfig.setClient((HexConfig.ClientConfigAccess)clientConfig.getLeft());
        HexConfig.setServer((HexConfig.ServerConfigAccess)serverConfig.getLeft());
        ModLoadingContext mlc = ModLoadingContext.get();
        mlc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getRight());
        mlc.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        mlc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    private static void initRegistry() {
        ForgeHexInitializer.bind(Registry.f_122898_, HexSounds::registerSounds);
        ForgeHexInitializer.bind(Registry.f_122901_, HexBlocks::registerBlocks);
        ForgeHexInitializer.bind(Registry.f_122904_, HexBlocks::registerBlockItems);
        ForgeHexInitializer.bind(Registry.f_122907_, HexBlockEntities::registerTiles);
        ForgeHexInitializer.bind(Registry.f_122904_, HexItems::registerItems);
        ForgeHexInitializer.bind(Registry.f_122915_, HexRecipeStuffRegistry::registerSerializers);
        ForgeHexInitializer.bind(Registry.f_122914_, HexRecipeStuffRegistry::registerTypes);
        ForgeHexInitializer.bind(Registry.f_122903_, HexEntities::registerEntities);
        ForgeHexInitializer.bind(Registry.f_122906_, HexParticles::registerParticles);
        ForgeHexArgumentTypeRegistry.ARGUMENT_TYPES.register(ForgeHexInitializer.getModEventBus());
        HexIotaTypes.registerTypes();
        HexAdvancementTriggers.registerTriggers();
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeHexInitializer.getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void initListeners() {
        IEventBus modBus = ForgeHexInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.register(ForgeHexClientInitializer.class));
        modBus.addListener(evt -> evt.enqueueWork(() -> {
            ForgePacketHandler.init();
            HexComposting.setup();
            HexStrippables.init();
            RegisterPatterns.registerPatterns();
            AkashicTreeGrower.init();
            HexInterop.init();
        }));
        modBus.addListener(evt -> {
            if (evt.getRegistryKey().equals((Object)Registry.f_122904_)) {
                CraftingHelper.register((ResourceLocation)ForgeUnsealedIngredient.ID, (IIngredientSerializer)ForgeUnsealedIngredient.Serializer.INSTANCE);
                CraftingHelper.register((ResourceLocation)ForgeModConditionalIngredient.ID, (IIngredientSerializer)ForgeModConditionalIngredient.Serializer.INSTANCE);
                HexStatistics.register();
                HexLootFunctions.registerSerializers((lift, id) -> Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)id, (Object)lift));
            }
        });
        modBus.addListener(evt -> HexAPI.LOGGER.info(PatternRegistry.getPatternCountInfo()));
        evBus.addListener(evt -> {
            InteractionResult res = Brainsweeping.tradeWithVillager(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), null);
            if (res.m_19077_()) {
                evt.setCanceled(true);
                evt.setCancellationResult(res);
            }
        });
        evBus.addListener(evt -> Brainsweeping.copyBrainsweepFromVillager(evt.getEntity(), evt.getOutcome()));
        evBus.addListener(evt -> {
            OpFlight.INSTANCE.tickDownFlight(evt.getEntity());
            ItemLens.tickLens((Entity)evt.getEntity());
        });
        evBus.addListener(evt -> {
            Level patt8672$temp;
            if (evt.phase == TickEvent.Phase.END && (patt8672$temp = evt.level) instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)patt8672$temp;
                PlayerPositionRecorder.updateAllPlayers(world);
            }
        });
        evBus.addListener(evt -> HexCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher()));
        evBus.addListener(evt -> {
            Optional pos = evt.getPosition();
            if (pos.isEmpty()) {
                return;
            }
            evt.setCanceled(ItemJewelerHammer.shouldFailToBreak(evt.getEntity(), evt.getState(), (BlockPos)pos.get()));
        });
        evBus.addListener(evt -> HexLootHandler.lootLoad(evt.getName(), builder -> evt.getTable().addPool(builder.m_79082_())));
        evBus.addListener(evt -> {
            Entity target = evt.getTarget();
            Entity patt9875$temp = evt.getTarget();
            if (patt9875$temp instanceof ServerPlayer) {
                Mob mob;
                ServerPlayer serverPlayer = (ServerPlayer)patt9875$temp;
                if (target instanceof Mob && IXplatAbstractions.INSTANCE.isBrainswept(mob = (Mob)target)) {
                    ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)MsgBrainsweepAck.of((Entity)mob));
                }
            }
        });
        evBus.addListener(evt -> {
            BlockState bs;
            Block output;
            if (!evt.isSimulated() && evt.getToolAction() == ToolActions.AXE_STRIP && (output = HexStrippables.STRIPPABLES.get((bs = evt.getState()).m_60734_())) != null) {
                evt.setFinalState(output.m_152465_(bs));
            }
        });
        modBus.addListener(ForgeCapabilityHandler::registerCaps);
        evBus.addGenericListener(ItemStack.class, ForgeCapabilityHandler::attachItemCaps);
        evBus.addGenericListener(BlockEntity.class, ForgeCapabilityHandler::attachBlockEntityCaps);
        evBus.addGenericListener(Entity.class, ForgeCapabilityHandler::attachEntityCaps);
        modBus.register(HexForgeDataGenerators.class);
        modBus.register(ForgeCapabilityHandler.class);
        evBus.register(CapSyncers.class);
        if (ModList.get().isLoaded("curios")) {
            modBus.addListener(CuriosApiInterop::onInterModEnqueue);
            modBus.addListener(CuriosApiInterop::onClientSetup);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(CuriosRenderers::onLayerRegister));
        }
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

