/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.recipe;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import org.jetbrains.annotations.NotNull;

public class ForgeUnsealedIngredient
extends AbstractIngredient {
    public static final ResourceLocation ID = HexAPI.modLoc("unsealed");
    private final ItemStack stack;

    private static ItemStack createStack(ItemStack base) {
        ItemStack newStack = base.m_41777_();
        NBTHelper.putString(newStack, "VisualOverride", "any");
        return newStack;
    }

    protected ForgeUnsealedIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(ForgeUnsealedIngredient.createStack(stack))));
        this.stack = stack;
    }

    public static ForgeUnsealedIngredient of(ItemStack stack) {
        return new ForgeUnsealedIngredient(stack);
    }

    public boolean test(@Nullable ItemStack input) {
        ADIotaHolder holder;
        if (input == null) {
            return false;
        }
        if (this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && (holder = IXplatAbstractions.INSTANCE.findDataHolder(this.stack)) != null) {
            return holder.readIotaTag() != null && holder.writeIota(new NullIota(), true);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(CraftingHelper.getID((IIngredientSerializer)PartialNBTIngredient.Serializer.INSTANCE)));
        json.addProperty("item", Objects.toString(Registry.f_122827_.m_7981_((Object)this.stack.m_41720_())));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ForgeUnsealedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public ForgeUnsealedIngredient parse(FriendlyByteBuf buffer) {
            return new ForgeUnsealedIngredient(buffer.m_130267_());
        }

        @NotNull
        public ForgeUnsealedIngredient parse(@NotNull JsonObject json) {
            return new ForgeUnsealedIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, ForgeUnsealedIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

