/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class BrainsweepProcessor
implements IComponentProcessor {
    private BrainsweepRecipe recipe;

    public void setup(IVariableProvider vars) {
        ResourceLocation id = new ResourceLocation(vars.get("recipe").asString());
        RecipeManager recman = Minecraft.m_91087_().f_91073_.m_7465_();
        List brainsweepings = recman.m_44013_(HexRecipeStuffRegistry.BRAINSWEEP_TYPE);
        for (BrainsweepRecipe poisonApples : brainsweepings) {
            if (!poisonApples.m_6423_().equals((Object)id)) continue;
            this.recipe = poisonApples;
            break;
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "header": {
                return IVariable.from((Object)this.recipe.result().m_60734_().m_49954_());
            }
            case "input": {
                List<ItemStack> inputStacks = this.recipe.blockIn().getDisplayedStacks();
                return IVariable.from((Object)inputStacks.toArray(new ItemStack[0]));
            }
            case "result": {
                return IVariable.from((Object)new ItemStack((ItemLike)this.recipe.result().m_60734_()));
            }
            case "entity": {
                ResourceLocation profession = Objects.requireNonNullElse(this.recipe.villagerIn().profession(), new ResourceLocation("toolsmith"));
                ResourceLocation biome = Objects.requireNonNullElse(this.recipe.villagerIn().biome(), new ResourceLocation("plains"));
                int level = this.recipe.villagerIn().minLevel();
                String iHatePatchouli = String.format("minecraft:villager{VillagerData:{profession:'%s',type:'%s',level:%d}}", profession, biome, level);
                return IVariable.wrap((String)iHatePatchouli);
            }
            case "entityTooltip": {
                Minecraft mc = Minecraft.m_91087_();
                return IVariable.wrapList(this.recipe.villagerIn().getTooltip(mc.f_91066_.f_92125_).stream().map(IVariable::from).toList());
            }
        }
        return null;
    }
}

