/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.utils;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.lib.HexItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PhialRecipeStackBuilder {
    private static ItemStack makeBattery(int unit, int size) {
        return ItemMediaBattery.withMedia(new ItemStack((ItemLike)HexItems.BATTERY), unit * size, unit * size);
    }

    public static Pair<List<ItemStack>, List<ItemStack>> createStacks() {
        ArrayList inputItems = Lists.newArrayList();
        ArrayList outputItems = Lists.newArrayList();
        int dust = HexConfig.common().dustMediaAmount();
        int shard = HexConfig.common().shardMediaAmount();
        int charged = HexConfig.common().chargedCrystalMediaAmount();
        if (dust > 0) {
            inputItems.add(new ItemStack((ItemLike)HexItems.AMETHYST_DUST, 1));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(dust, 1));
            inputItems.add(new ItemStack((ItemLike)HexItems.AMETHYST_DUST, 64));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(dust, 64));
        }
        if (shard > 0) {
            inputItems.add(new ItemStack((ItemLike)Items.f_151049_, 1));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(shard, 1));
            inputItems.add(new ItemStack((ItemLike)Items.f_151049_, 64));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(shard, 64));
        }
        if (charged > 0) {
            inputItems.add(new ItemStack((ItemLike)HexItems.CHARGED_AMETHYST, 1));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(charged, 1));
            inputItems.add(new ItemStack((ItemLike)HexItems.CHARGED_AMETHYST, 64));
            outputItems.add(PhialRecipeStackBuilder.makeBattery(charged, 64));
        }
        return new Pair((Object)inputItems, (Object)outputItems);
    }

    public static boolean shouldAddRecipe() {
        return HexConfig.common().dustMediaAmount() > 0 || HexConfig.common().shardMediaAmount() > 0 || HexConfig.common().chargedCrystalMediaAmount() > 0;
    }
}

