/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.mixin.accessor.AccessorLootTable;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ReloadableServerResources.class})
public class MixinReloadableServerResources {
    @Inject(method={"loadResources"}, at={@At(value="RETURN")}, cancellable=true)
    private static void onLoadResources(CallbackInfoReturnable<CompletableFuture<ReloadableServerResources>> cir) {
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).thenApply(rsr -> {
            LootTable amethystTable = rsr.m_206885_().m_79217_(Blocks.f_152492_.m_60589_());
            AccessorLootTable theCoolerAmethystTable = (AccessorLootTable)amethystTable;
            LootItemFunction[] oldFuncs = theCoolerAmethystTable.hex$getFunctions();
            LootItemFunction[] newFuncs = Arrays.copyOf(oldFuncs, oldFuncs.length + 1);
            LootItemFunction shardReducer = rsr.m_206886_().m_165108_(HexLootHandler.FUNC_AMETHYST_SHARD_REDUCER);
            if (shardReducer != null) {
                newFuncs[newFuncs.length - 1] = shardReducer;
                theCoolerAmethystTable.hex$setFunctions(newFuncs);
                theCoolerAmethystTable.hex$setCompositeFunction(LootItemFunctions.m_80770_((BiFunction[])newFuncs));
            } else {
                HexAPI.LOGGER.warn("{} was not found?", (Object)HexLootHandler.FUNC_AMETHYST_SHARD_REDUCER);
            }
            return rsr;
        }));
    }
}

