/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.codecs.predicates.NbtPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record RestrictedItemPredicate(Item item, NbtPredicate nbt, MinMaxBounds.Ints durability, MinMaxBounds.Ints count) {
    public static final Codec<RestrictedItemPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("id").forGetter(RestrictedItemPredicate::item), (App)NbtPredicate.CODEC.fieldOf("nbt").orElse((Object)NbtPredicate.ANY).forGetter(RestrictedItemPredicate::nbt), (App)CodecExtras.passthrough(MinMaxBounds::m_55328_, MinMaxBounds.Ints::m_55373_).fieldOf("durability").orElse((Object)MinMaxBounds.Ints.f_55364_).forGetter(RestrictedItemPredicate::durability), (App)CodecExtras.passthrough(MinMaxBounds::m_55328_, MinMaxBounds.Ints::m_55373_).fieldOf("count").orElse((Object)MinMaxBounds.Ints.f_55364_).forGetter(RestrictedItemPredicate::count)).apply((Applicative)instance, RestrictedItemPredicate::new));

    public Optional<CompoundTag> getTag() {
        if (this.nbt() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.nbt().tag());
    }

    public boolean matches(ItemStack stack) {
        if (this.item == null) {
            return false;
        }
        if (stack.m_150930_(this.item)) {
            return false;
        }
        if (!this.durability.m_55327_() && !stack.m_41763_()) {
            return false;
        }
        if (!this.durability.m_55390_(stack.m_41776_() - stack.m_41773_())) {
            return false;
        }
        if (!this.count.m_55390_(stack.m_41613_())) {
            return false;
        }
        return this.nbt.matches(stack);
    }
}

