/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib;

import java.util.Objects;

public class ChunkPos {
    public final int x;
    public final int z;

    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getRegionX() {
        return this.x >> 5;
    }

    public int getRegionZ() {
        return this.z >> 5;
    }

    public ChunkPos toRegionPos() {
        return new ChunkPos(this.getRegionX(), this.getRegionZ());
    }

    public int getRegionLocalX() {
        return this.x & 0x1F;
    }

    public int getRegionLocalZ() {
        return this.z & 0x1F;
    }

    public int getRegionChunkIndex() {
        return this.getRegionLocalX() | this.getRegionLocalZ() << 5;
    }

    public static ChunkPos fromMCAorMCC(String fileName) {
        fileName = fileName.substring(fileName.indexOf(".") + 1, fileName.lastIndexOf("."));
        int x = Integer.parseInt(fileName.substring(0, fileName.indexOf(".")));
        int z = Integer.parseInt(fileName.substring(fileName.indexOf(".") + 1));
        return new ChunkPos(x, z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPos chunkPos = (ChunkPos)o;
        return this.x == chunkPos.x && this.z == chunkPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return "ChunkPos{x=" + this.x + ", z=" + this.z + '}';
    }
}

