/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.entity.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class PredicateAttackGoal<T extends LivingEntity>
extends TargetGoal {
    private final Predicate<Mob> canOwnerTarget;
    private final Class<T> targetClass;
    private final int targetChance;
    private LivingEntity nearestTarget;
    private final TargetingConditions targetEntitySelector;

    public PredicateAttackGoal(Mob goalOwnerIn, Class<T> targetClassIn, boolean checkSight, Predicate<Mob> canOwnerTarget) {
        this(goalOwnerIn, targetClassIn, checkSight, false, canOwnerTarget);
    }

    public PredicateAttackGoal(Mob goalOwnerIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn, Predicate<Mob> canOwnerTarget) {
        this(goalOwnerIn, targetClassIn, 10, checkSight, nearbyOnlyIn, null, canOwnerTarget);
    }

    public PredicateAttackGoal(Mob goalOwnerIn, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, @Nullable Predicate<LivingEntity> targetPredicate, Predicate<Mob> canOwnerTarget) {
        super(goalOwnerIn, checkSight, nearbyOnlyIn);
        this.canOwnerTarget = canOwnerTarget;
        this.targetClass = targetClassIn;
        this.targetChance = targetChanceIn;
        this.targetEntitySelector = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(targetPredicate);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (!this.canOwnerTarget.test(this.f_26135_) || this.targetChance > 0 && this.f_26135_.m_217043_().m_188503_(this.targetChance) != 0) {
            return false;
        }
        this.findNearestTarget();
        return this.nearestTarget != null;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    protected void findNearestTarget() {
        this.nearestTarget = this.targetClass != Player.class && this.targetClass != ServerPlayer.class ? this.f_26135_.f_19853_.m_45963_(this.targetClass, this.targetEntitySelector, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_(), this.getTargetableArea(this.m_7623_())) : this.f_26135_.f_19853_.m_45949_(this.targetEntitySelector, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.nearestTarget);
        super.m_8056_();
    }
}

