/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.core.endimator.EndimatablePart;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.EndimationKeyframe;
import com.teamabnormals.blueprint.core.endimator.KeyframeType;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public final class Endimator {
    private static final Vector3f ADD_VECTOR = new Vector3f();
    private final Map<String, PosedPart> poseMap;

    public Endimator(Map<String, PosedPart> poseMap) {
        this.poseMap = poseMap;
    }

    public Endimator() {
        this.poseMap = new HashMap<String, PosedPart>();
    }

    public static Endimator compile(ModelPart root) {
        return new Endimator(Endimator.compileMap(new HashMap<String, PosedPart>(), root));
    }

    public static Endimator treeCompile(ModelPart root) {
        return new Endimator(Endimator.compileMap(new HashMap<String, PosedPart>(), "", root));
    }

    private static Map<String, PosedPart> compileMap(Map<String, PosedPart> partMap, ModelPart root) {
        root.f_104213_.forEach((childName, childPart) -> {
            partMap.put((String)childName, PosedPart.part((EndimatablePart)childPart));
            if (!childPart.f_104213_.isEmpty()) {
                Endimator.compileMap(partMap, childPart);
            }
        });
        return partMap;
    }

    private static Map<String, PosedPart> compileMap(Map<String, PosedPart> partMap, String prefix, ModelPart root) {
        root.f_104213_.forEach((childName, childPart) -> {
            String path = prefix + childName;
            partMap.put(path, PosedPart.part((EndimatablePart)childPart));
            if (!childPart.f_104213_.isEmpty()) {
                Endimator.compileMap(partMap, path + "/", childPart);
            }
        });
        return partMap;
    }

    private static void applyType(PosedPart posedPart, KeyframeType type, EndimationKeyframe[] frames, float blendWeight, float time) {
        int toIndex;
        int length = frames.length;
        if (length <= 0) {
            return;
        }
        int fromIndex = Mth.m_14049_((int)0, (int)length, i -> time <= frames[i].time) - 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((toIndex = fromIndex + 1) > length - 1) {
            toIndex = length - 1;
        }
        EndimationKeyframe from = frames[fromIndex];
        float fromTime = from.time;
        EndimationKeyframe to = frames[toIndex];
        to.apply(ADD_VECTOR, frames, from, to, toIndex, length, Mth.m_14036_((float)((time - fromTime) / (to.time - fromTime)), (float)0.0f, (float)1.0f));
        type.apply(posedPart, ADD_VECTOR, blendWeight);
    }

    public void put(String name, EndimatablePart part) {
        this.poseMap.put(name, PosedPart.part(part));
    }

    public void putRecursive(String prefix, ModelPart part, boolean notRoot) {
        Map<String, PosedPart> poseMap = this.poseMap;
        poseMap.put((String)prefix, PosedPart.part((EndimatablePart)part));
        if (notRoot) {
            prefix = (String)prefix + "/";
        }
        for (Map.Entry entry : part.f_104213_.entrySet()) {
            this.putRecursive((String)prefix + (String)entry.getKey(), (ModelPart)entry.getValue(), true);
        }
    }

    public void putShortRecursive(String name, ModelPart part) {
        this.poseMap.put(name, PosedPart.part((EndimatablePart)part));
        part.f_104213_.forEach(this::putShortRecursive);
    }

    @Nullable
    public PosedPart remove(String name) {
        return this.poseMap.remove(name);
    }

    public void removeShortRecursive(String name, ModelPart part) {
        this.poseMap.remove(name);
        for (Map.Entry entry : part.f_104213_.entrySet()) {
            this.removeShortRecursive((String)entry.getKey(), (ModelPart)entry.getValue());
        }
    }

    public void removeRecursive(String prefix, ModelPart part, boolean notRoot) {
        Map<String, PosedPart> poseMap = this.poseMap;
        poseMap.remove(prefix);
        if (notRoot) {
            prefix = (String)prefix + "/";
        }
        for (Map.Entry entry : part.f_104213_.entrySet()) {
            this.removeRecursive((String)prefix + (String)entry.getKey(), (ModelPart)entry.getValue(), true);
        }
    }

    @Nullable
    public PosedPart getPosedPart(String name) {
        return this.poseMap.get(name);
    }

    public void reset(ResetMode resetMode) {
        if (resetMode != ResetMode.NONE) {
            this.poseMap.values().forEach(resetMode.consumer);
        }
    }

    public void clear() {
        this.poseMap.clear();
    }

    public Map<String, PosedPart> getPoseMap() {
        return this.poseMap;
    }

    public void apply(Endimation endimation, float time, ResetMode resetMode) {
        this.apply(endimation, time, 1.0f, resetMode);
    }

    public void apply(Endimation endimation, float time, float weight, ResetMode resetMode) {
        this.reset(resetMode);
        ObjectIterator partKeyframesIterator = Object2ObjectMaps.fastIterator(endimation.getPartKeyframes());
        Map<String, PosedPart> poseMap = this.poseMap;
        float blendWeight = endimation.getBlendWeight() * weight;
        while (partKeyframesIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)partKeyframesIterator.next();
            PosedPart posedPart = poseMap.get(entry.getKey());
            if (posedPart == null) continue;
            Endimation.PartKeyframes partKeyframes = (Endimation.PartKeyframes)entry.getValue();
            Endimator.applyType(posedPart, KeyframeType.POSITION, partKeyframes.getPosFrames(), blendWeight, time);
            Endimator.applyType(posedPart, KeyframeType.ROTATION, partKeyframes.getRotationFrames(), blendWeight, time);
            Endimator.applyType(posedPart, KeyframeType.OFFSET, partKeyframes.getOffsetFrames(), blendWeight, time);
            Endimator.applyType(posedPart, KeyframeType.SCALE, partKeyframes.getScaleFrames(), blendWeight, time);
            posedPart.apply();
        }
    }

    public static final class PosedPart {
        public final EndimatablePart part;
        public float x;
        public float y;
        public float z;
        public float xRot;
        public float yRot;
        public float zRot;
        public float xOffset;
        public float yOffset;
        public float zOffset;
        public float xScale;
        public float yScale;
        public float zScale;

        public PosedPart(EndimatablePart part) {
            this.part = part;
        }

        public static PosedPart part(EndimatablePart part) {
            return new PosedPart(part);
        }

        public void apply() {
            EndimatablePart part = this.part;
            part.addPos(this.x, this.y, this.z);
            part.addRotation(this.xRot, this.yRot, this.zRot);
            part.addOffset(this.xOffset, this.yOffset, this.zOffset);
            part.addScale(this.xScale, this.yScale, this.zScale);
        }

        public void unapply() {
            EndimatablePart part = this.part;
            part.addPos(-this.x, -this.y, -this.z);
            part.addRotation(-this.xRot, -this.yRot, -this.zRot);
            part.addOffset(-this.xOffset, -this.yOffset, -this.zOffset);
            part.addScale(-this.xScale, -this.yScale, -this.zScale);
        }

        public void reset() {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.xRot = 0.0f;
            this.yRot = 0.0f;
            this.zRot = 0.0f;
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
            this.zOffset = 0.0f;
            this.xScale = 0.0f;
            this.yScale = 0.0f;
            this.zScale = 0.0f;
        }

        public void addPos(float x, float y, float z) {
            this.x += x;
            this.y += y;
            this.z += z;
        }

        public void addRotation(float x, float y, float z) {
            this.xRot += x;
            this.yRot += y;
            this.zRot += z;
        }

        public void addOffset(float x, float y, float z) {
            this.xOffset += x;
            this.yOffset += y;
            this.zOffset += z;
        }

        public void addScale(float x, float y, float z) {
            this.xScale += x;
            this.yScale += y;
            this.zScale += z;
        }

        public void applyAdd(Consumer<PosedPart> consumer) {
            this.unapply();
            consumer.accept(this);
            this.apply();
        }
    }

    public static enum ResetMode {
        NONE(posedPart -> {}),
        ALL(posedPart -> {
            posedPart.unapply();
            posedPart.reset();
        }),
        RESET(PosedPart::reset),
        UNAPPLY(PosedPart::unapply);

        private final Consumer<PosedPart> consumer;

        private ResetMode(Consumer<PosedPart> consumer) {
            this.consumer = consumer;
        }

        public Consumer<PosedPart> getConsumer() {
            return this.consumer;
        }
    }
}

