/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.interpolation;

import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class EndimationEasers {
    public static final BasicRegistry<Function<Float, Float>> REGISTRY = new BasicRegistry();
    public static final Function<Float, Float> LINEAR = EndimationEasers.register("linear", Function.identity());
    public static final Function<Float, Float> EASE_IN_SINE = EndimationEasers.register("ease_in_sine", (Float progress) -> Float.valueOf(1.0f - (float)Math.cos(1.5707964f * progress.floatValue())));
    public static final Function<Float, Float> EASE_OUT_SINE = EndimationEasers.register("ease_out_sine", (Float progress) -> Float.valueOf((float)Math.sin(1.5707964f * progress.floatValue())));
    public static final Function<Float, Float> EASE_IN_OUT_SINE = EndimationEasers.register("ease_in_out_sine", (Float progress) -> Float.valueOf((float)((-Math.cos(Math.PI * (double)progress.floatValue()) + 1.0) * 0.5)));
    public static final Function<Float, Float> EASE_IN_CUBIC = EndimationEasers.register("ease_in_cubic", (Float progress) -> Float.valueOf(progress.floatValue() * progress.floatValue() * progress.floatValue()));
    public static final Function<Float, Float> EASE_OUT_CUBIC = EndimationEasers.register("ease_out_cubic", (Float progress) -> {
        float base = 1.0f - progress.floatValue();
        return Float.valueOf(1.0f - base * base * base);
    });
    public static final Function<Float, Float> EASE_IN_OUT_CUBIC = EndimationEasers.register("ease_in_out_cubic", (Float progress) -> {
        if (progress.floatValue() < 0.5f) {
            return Float.valueOf(4.0f * progress.floatValue() * progress.floatValue() * progress.floatValue());
        }
        float base = -2.0f * progress.floatValue() + 2.0f;
        return Float.valueOf(1.0f - base * base * base * 0.5f);
    });

    private EndimationEasers() {
    }

    private static Function<Float, Float> register(String name, Function<Float, Float> easer) {
        REGISTRY.register(new ResourceLocation(name), easer);
        return easer;
    }

    public static synchronized Function<Float, Float> register(ResourceLocation name, Function<Float, Float> easer) {
        REGISTRY.register(name, easer);
        return easer;
    }
}

