/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.IItemMode;
import com.mowmaster.mowlib.Items.Filters.IPedestalFilter;
import com.mowmaster.mowlib.Items.Filters.MowLibBaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.pedestals.Items.Filters.FilterRestricted;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BaseFilter
extends MowLibBaseFilter {
    public boolean filterType = false;
    public IPedestalFilter.FilterDirection filterableDirection;

    public BaseFilter(Item.Properties p_41383_, IPedestalFilter.FilterDirection direction) {
        super(p_41383_, direction);
        this.filterableDirection = direction;
    }

    public int canAcceptCountItems(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, ItemStack itemStackIncoming) {
        List stackCurrent = this.readFilterQueueFromNBT(filterStack, IItemMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountItems(filterableBlockEntity, itemFromInv, itemStackIncoming.m_41741_(), spaceAvailable, itemStackIncoming);
        }
        return Math.min(spaceAvailable, itemStackIncoming.m_41741_());
    }

    public int canAcceptCountFluids(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, FluidStack incomingFluidStack) {
        List stackCurrent = this.readFilterQueueFromNBT(filterStack, IItemMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountFluids(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingFluidStack);
        }
        return Math.min(spaceAvailable, incomingFluidStack.getAmount());
    }

    public int canAcceptCountEnergy(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingEnergyAmount) {
        List stackCurrent = this.readFilterQueueFromNBT(filterStack, IItemMode.ItemTransferMode.ENERGY);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountEnergy(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingEnergyAmount);
        }
        return Math.min(spaceAvailable, incomingEnergyAmount);
    }

    public int canAcceptCountExperience(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingExperienceAmount) {
        List stackCurrent = this.readFilterQueueFromNBT(filterStack, IItemMode.ItemTransferMode.EXPERIENCE);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountExperience(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingExperienceAmount);
        }
        return Math.min(spaceAvailable, incomingExperienceAmount);
    }

    public int canAcceptCountDust(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, DustMagic incomingDust) {
        List stackCurrent = this.readFilterQueueFromNBT(filterStack, IItemMode.ItemTransferMode.DUST);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountDust(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingDust);
        }
        return Math.min(spaceAvailable, incomingDust.getDustAmount());
    }

    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        if (!filterStack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get())) {
            ArrayList listed = new ArrayList();
            for (IItemMode.ItemTransferMode mode : IItemMode.ItemTransferMode.values()) {
                List filterQueue = this.readFilterQueueFromNBT(filterStack, mode);
                if (filterQueue.size() <= 0) continue;
                MowLibMessageUtils.messagePlayerChat((Player)player, (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (String)"pedestals.filters.tooltip_filterlist");
                ArrayList<Object> enchantList = new ArrayList<Object>();
                for (int j = 0; j < filterQueue.size(); ++j) {
                    if (((ItemStack)filterQueue.get(j)).m_41619_()) continue;
                    if (j + 1 >= filterQueue.size()) {
                        enchantList.add(((ItemStack)filterQueue.get(j)).m_41611_().getString());
                        continue;
                    }
                    enchantList.add(((ItemStack)filterQueue.get(j)).m_41611_().getString() + ", ");
                }
                MowLibMessageUtils.messagePlayerChatWithAppend((String)"pedestals", (Player)player, (ChatFormatting)ChatFormatting.GRAY, (String)(filterStack.m_41611_().getString() + " |--->  "), enchantList);
            }
        } else {
            MowLibMessageUtils.messagePlayerChat((Player)player, (ChatFormatting)ChatFormatting.DARK_RED, (String)"pedestals.baseItem");
        }
    }
}

