/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.MechanicalOnlyStorage;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.BaseDustDropItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BaseDustBulkStorageItem
extends BaseDustDropItem
implements IBulkItem {
    private int counter = 0;

    public BaseDustBulkStorageItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private int getDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            return BaseDustBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        this.setDischargeCounter(stack);
        return 0;
    }

    private void increaseDischargeCounter(ItemStack stack) {
        int current = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            current = BaseDustBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        BaseDustBulkStorageItem.writeIntegerToNBT("pedestals", tag, current + 1, "_dischargeCounter");
    }

    private void setDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseDustBulkStorageItem.writeIntegerToNBT("pedestals", tag, 0, "_dischargeCounter");
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static int getItemColor() {
        return 13659647;
    }

    public int getMaxAllowedStorage() {
        return (Integer)PedestalConfig.COMMON.pedestal_baseDustStorage.get() + (Integer)PedestalConfig.COMMON.augment_t4StorageDust.get() * (Integer)PedestalConfig.COMMON.augment_t4StorageInsertSize.get();
    }

    public int getItemVariant(ItemStack stack) {
        DustMagic dust = DustMagic.getDustMagicInItemStack((ItemStack)stack);
        if (!dust.isEmpty()) {
            double renderDevider = 100.0 * (double)(dust.getDustAmount() / this.getMaxAllowedStorage());
            if (renderDevider <= 25.0) {
                return 0;
            }
            if (renderDevider <= 50.0) {
                return 1;
            }
            if (renderDevider <= 75.0) {
                return 2;
            }
            if (renderDevider >= 100.0) {
                return 3;
            }
        }
        return 0;
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41405_.m_5776_()) {
            Player player;
            boolean survival = true;
            if (p_41406_ instanceof Player && (player = (Player)p_41406_).m_7500_()) {
                survival = false;
            }
            if (survival && ((Boolean)PedestalConfig.COMMON.bulkstorage_dustDischarge_toggle.get()).booleanValue()) {
                DustMagic dust = DustMagic.getDustMagicInItemStack((ItemStack)p_41404_);
                if (!dust.isEmpty()) {
                    ++this.counter;
                    if (this.counter >= 20) {
                        this.increaseDischargeCounter(p_41404_);
                        this.counter = 0;
                    }
                }
                if (this.getDischargeCounter(p_41404_) >= (Integer)PedestalConfig.COMMON.bulkstorage_dustDischarge.get()) {
                    if (p_41406_ instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)p_41406_;
                        this.removeDust(livingEntity, p_41404_);
                    }
                    p_41404_.m_41774_(1);
                }
            }
        }
    }

    public MobEffect getEffect() {
        Random rand = new Random();
        Map NEGEFFECT = Map.ofEntries(Map.entry(0, MobEffects.f_19594_), Map.entry(1, MobEffects.f_19610_), Map.entry(2, MobEffects.f_19619_), Map.entry(3, MobEffects.f_19612_), Map.entry(4, MobEffects.f_19602_), Map.entry(5, MobEffects.f_19620_), Map.entry(6, MobEffects.f_19599_), Map.entry(7, MobEffects.f_19604_), Map.entry(8, MobEffects.f_19614_), Map.entry(9, MobEffects.f_19597_), Map.entry(10, MobEffects.f_19590_), Map.entry(11, MobEffects.f_19613_), Map.entry(12, MobEffects.f_19615_), Map.entry(13, MobEffects.f_19609_), Map.entry(14, MobEffects.f_216964_), Map.entry(15, MobEffects.f_19591_));
        return NEGEFFECT.getOrDefault(rand.nextInt(16), MobEffects.f_216964_);
    }

    public void removeDust(LivingEntity entity, ItemStack stack) {
        DustMagic dust = DustMagic.getDustMagicInItemStack((ItemStack)stack);
        if (!dust.isEmpty()) {
            entity.m_7292_(new MobEffectInstance(this.getEffect(), dust.getDustAmount(), this.getItemVariant(stack)));
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int charge;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        DustMagic stored = DustMagic.getDustMagicInItemStack((ItemStack)p_41421_);
        if (!stored.isEmpty()) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_dust"), (ChatFormatting)ChatFormatting.GOLD);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(MowLibColorReference.getColorName((int)stored.getDustColor()) + ": " + stored.getDustAmount())), (ChatFormatting)ChatFormatting.WHITE);
        }
        if ((charge = this.getDischargeCounter(p_41421_)) > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_dust_discharge"), (ChatFormatting)ChatFormatting.RED);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(charge + "/" + PedestalConfig.COMMON.bulkstorage_dustDischarge.get())), (ChatFormatting)ChatFormatting.WHITE);
        }
    }
}

