/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeBlockBreaker
extends ItemUpgradeBase {
    public ItemUpgradeBlockBreaker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifyRemoveDurabilityCost(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get();
    }

    @Override
    public boolean canModifyRepairTool(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
            if (((Boolean)PedestalConfig.COMMON.blockBreakerRequireTools.get()).booleanValue() && pedestal.getActualToolStack().m_41619_()) {
                messages.add(ChatFormatting.BLACK + "Needs Tool");
            }
            if (((Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get()).booleanValue() && pedestal.hasTool() && pedestal.getDurabilityRemainingOnInsertedTool() <= 1) {
                messages.add(ChatFormatting.BLACK + "Inserted Tool");
                messages.add(ChatFormatting.RED + "Is Broken");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        if (((Boolean)PedestalConfig.COMMON.blockBreakerRequireTools.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Items.f_42427_);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions(coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal);
        if (allPositions.isEmpty()) {
            return;
        }
        this.upgradeRepairTool(pedestal);
        this.breakerAction(level, pedestal, allPositions);
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean isToolHighEnoughLevelForBlock(ItemStack toolIn, BlockState getBlock) {
        Item item = toolIn.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier toolTier = tieredItem.m_43314_();
            return TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)getBlock);
        }
        return false;
    }

    private List<ItemStack> getBlockDrops(BasePedestalBlockEntity pedestal, BlockState blockTarget, BlockPos posTarget) {
        ItemStack getToolFromPedestal = pedestal.getToolStack().m_41619_() ? new ItemStack((ItemLike)Items.f_42427_) : pedestal.getToolStack();
        Level level = pedestal.m_58904_();
        if (blockTarget.m_60734_() != Blocks.f_50016_) {
            WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
            if (getPlayer != null && getPlayer.get() != null) {
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78984_(LootContextParams.f_81455_, (Object)((Entity)getPlayer.get())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
                return blockTarget.m_60724_(builder);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
            return blockTarget.m_60724_(builder);
        }
        return new ArrayList<ItemStack>();
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = ItemStack.f_41583_;
            if (canMineBlock.m_60734_() instanceof Block) {
                blockToCheck = canMineBlock.m_60734_().m_7397_((BlockGetter)pedestal.m_58904_(), canMinePos, canMineBlock);
            }
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    public boolean allowRun(BasePedestalBlockEntity pedestal, boolean damage) {
        if (((Boolean)PedestalConfig.COMMON.blockBreakerRequireTools.get()).booleanValue()) {
            if (pedestal.hasTool()) {
                if (damage) {
                    return pedestal.damageInsertedTool(1, true);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void breakerAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> listed) {
        WeakReference<FakePlayer> getPlayer;
        if (!level.m_5776_() && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
            BlockEvent.BreakEvent e;
            int currentPosition = this.getCurrentPosition(pedestal);
            BlockPos currentPoint = listed.get(currentPosition);
            BlockState blockAtPoint = level.m_8055_(currentPoint);
            boolean damage = this.canDamageTool(level, pedestal, (Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get());
            boolean allowrun = this.allowRun(pedestal, (Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get());
            boolean fuelRemoved = true;
            if (!blockAtPoint.m_60734_().equals(Blocks.f_50016_) && blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f && allowrun && this.passesFilter(pedestal, blockAtPoint, currentPoint) && !ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_()) && ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) && !MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, currentPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()))) && !currentPoint.equals((Object)pedestal.getPos()) && this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true)) {
                if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), false)) {
                    boolean canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                    List<ItemStack> drops = this.getBlockDrops(pedestal, blockAtPoint, currentPoint);
                    if (level.m_7702_(currentPoint) != null) {
                        if (canRemoveBlockEntities) {
                            blockAtPoint.m_60753_(level, currentPoint, blockAtPoint, true);
                            this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                            level.m_46747_(currentPoint);
                            level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                            if (damage) {
                                this.upgradeDamageInsertedTool(pedestal, 1, false);
                            }
                            if (drops.size() > 0) {
                                for (ItemStack stack : drops) {
                                    MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                                }
                            }
                        }
                    } else {
                        this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                        level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                        if (damage) {
                            this.upgradeDamageInsertedTool(pedestal, 1, false);
                        }
                        if (drops.size() > 0) {
                            for (ItemStack stack : drops) {
                                MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                            }
                        }
                    }
                } else {
                    fuelRemoved = false;
                }
            }
            if (currentPosition + 1 >= listed.size()) {
                this.setCurrentPosition(pedestal, 0);
            } else if (fuelRemoved) {
                this.iterateCurrentPosition(pedestal);
            }
        }
    }
}

