/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class ItemUpgradeCharger
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeCharger(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        ArrayList<String> messages = new ArrayList<String>();
        if (pedestal.getItemInPedestal().m_41619_() && pedestal.getStoredEnergy() <= 0) {
            boolean hasItem = MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (String)"hasitem");
            if (pedestal.getStoredEnergy() <= 0 && hasItem) {
                messages.add(ChatFormatting.RED + "Needs Energy");
            }
        }
        return messages;
    }

    private boolean canProcess(ItemStack toProcess) {
        LazyOptional cap = toProcess.getCapability(ForgeCapabilities.ENERGY);
        if (cap.isPresent()) {
            IEnergyStorage energyHandler = (IEnergyStorage)cap.orElse(null);
            return !toProcess.m_41619_() && energyHandler != null;
        }
        return false;
    }

    public Optional<Integer> getFirstSlotWithItemThatCanBeProcessed(BasePedestalBlockEntity pedestal, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (!this.canProcess(stackInSlot) || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !ItemUpgradeCharger.passesItemFilter(pedestal, stackInSlot) || !this.canProcess(stackInSlot)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        BlockPos inventoryPos = this.getPosOfBlockBelow(level, pedestal.getPos(), 1);
        BlockEntity invToPullFrom = level.m_7702_(inventoryPos);
        if (invToPullFrom instanceof BasePedestalBlockEntity) {
            return;
        }
        MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)inventoryPos, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true).ifPresent(handler -> {
            Optional<Integer> slotToHandle = this.getFirstSlotWithItemThatCanBeProcessed(pedestal, (IItemHandler)handler);
            if (this.canTransferEnergy(coin)) {
                slotToHandle.ifPresent(i -> {
                    IEnergyStorage energyHandler;
                    LazyOptional cap;
                    ItemStack itemFromInv = handler.getStackInSlot(i.intValue());
                    if (!itemFromInv.m_41619_() && (cap = itemFromInv.getCapability(ForgeCapabilities.ENERGY)).isPresent() && (energyHandler = (IEnergyStorage)cap.orElse(null)) != null) {
                        if (energyHandler.canReceive()) {
                            int baseRate;
                            int maxRate;
                            int transferRate;
                            int getEnergyInPedestal = pedestal.getStoredEnergy();
                            int containerCurrentEnergy = energyHandler.getEnergyStored();
                            int getContainerMaxEnergy = energyHandler.getMaxEnergyStored();
                            int getSpaceForEnergy = getContainerMaxEnergy - containerCurrentEnergy;
                            int n = transferRate = getSpaceForEnergy >= (maxRate = (baseRate = ((Integer)PedestalConfig.COMMON.upgrade_import_baseEnergyTransferSpeed.get()).intValue()) + this.getEnergyCapacityIncrease(pedestal.getCoinOnPedestal())) ? maxRate : getSpaceForEnergy;
                            if (getEnergyInPedestal < transferRate) {
                                transferRate = getEnergyInPedestal;
                            }
                            int chargeItemLimit = energyHandler.receiveEnergy(transferRate, true);
                            if (getSpaceForEnergy <= 0) {
                                if (pedestal.addItemStack(itemFromInv, true).m_41619_()) {
                                    pedestal.addItemStack(itemFromInv, false);
                                    handler.extractItem(i.intValue(), 1, false);
                                }
                            } else if (energyHandler.receiveEnergy(chargeItemLimit, true) > 0) {
                                int removedFromPedestal = pedestal.removeEnergy(chargeItemLimit, false);
                                energyHandler.receiveEnergy(removedFromPedestal, false);
                            }
                        } else if (pedestal.addItemStack(itemFromInv, true).m_41619_()) {
                            pedestal.addItemStack(itemFromInv, false);
                            handler.extractItem(i.intValue(), 1, false);
                        }
                    }
                });
            }
        });
    }
}

