/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardArea;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeMilker
extends ItemUpgradeBase {
    public ItemUpgradeMilker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_milker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_milker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_milker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_milker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42446_);
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack toolStack;
        boolean usingItem;
        if (level.m_5776_()) {
            return;
        }
        if (!this.removeFuelForAction(pedestal, 0, true)) {
            return;
        }
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        boolean bl = usingItem = !itemInPedestal.m_41619_();
        if (usingItem) {
            toolStack = itemInPedestal;
        } else {
            toolStack = pedestal.getToolStack();
            Fluid milk = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("minecraft:milk"));
            if (milk != null && !milk.m_6212_(Fluids.f_76191_)) {
                return;
            }
            if (pedestal.spaceForFluid() < 1000) {
                return;
            }
        }
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
                List<Animal> animals = WorkCardArea.getEntitiesInRangeOfUpgrade(level, Animal.class, workCardItemStack, pedestal);
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toolStack.m_41777_());
                for (Animal animal : animals) {
                    BlockPos animalPos = animal.m_20097_();
                    InteractionResult result = animal.m_6071_((Player)fakePlayer, InteractionHand.MAIN_HAND);
                    if (result != InteractionResult.CONSUME) continue;
                    for (ItemStack stackInPlayer : fakePlayer.m_150109_().f_35974_) {
                        FluidStack fluidStack;
                        BucketItem bucket;
                        ItemStack toRemove;
                        if (stackInPlayer.m_41619_() || toolStack.m_41720_().equals(stackInPlayer.m_41720_()) || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestalPos, animalPos), false)) continue;
                        if (usingItem) {
                            toRemove = toolStack.m_41777_();
                            toRemove.m_41764_(1);
                            if (pedestal.removeItemStack(toRemove, false).m_41619_()) continue;
                            MowLibItemUtils.spawnItemStack((Level)level, (double)animalPos.m_123341_(), (double)animalPos.m_123342_(), (double)animalPos.m_123343_(), (ItemStack)stackInPlayer);
                            if (this.hasSuperSpeed(coin)) continue;
                            return;
                        }
                        toRemove = stackInPlayer.m_41720_();
                        if (!(toRemove instanceof BucketItem) || (bucket = (BucketItem)toRemove).getFluid().m_6212_(Fluids.f_76191_) || pedestal.addFluid(fluidStack = new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE) <= 0 || this.hasSuperSpeed(coin)) continue;
                        return;
                    }
                }
            }
        }
    }
}

