/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.UpgradeModificationGlobalRecipe;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ItemUpgradeModifications
extends ItemUpgradeBase {
    public ItemUpgradeModifications(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 3;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions(coinInPedestal);
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal);
        if (allPositions.isEmpty()) {
            return;
        }
        this.modifierAction(level, pedestal, allPositions);
    }

    protected Optional<UpgradeModificationGlobalRecipe> getModificationGlobalRecipe(Level level, ItemStack upgradeInput, List<ItemStack> pedestalInputs) {
        List<ItemStack> filteredInputs = pedestalInputs.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
        SimpleContainer container = new SimpleContainer(filteredInputs.size() + 1);
        container.m_6836_(0, upgradeInput);
        for (int i = 0; i < filteredInputs.size(); ++i) {
            container.m_6836_(i + 1, filteredInputs.get(i));
        }
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44015_((RecipeType)UpgradeModificationGlobalRecipe.Type.INSTANCE, (Container)container, level);
    }

    public void modifierAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> allPositions) {
        BlockPos inventoryPos = this.getPosOfBlockBelow(level, pedestal.getPos(), 1);
        if (level.m_7702_(inventoryPos) instanceof BasePedestalBlockEntity) {
            return;
        }
        BlockPos modificationBlockPos = pedestal.getPos();
        BlockPos modificationParticleBlockPos = this.getPosOfBlockBelow(level, modificationBlockPos, -1);
        List ingredientPedestals = allPositions.stream().map(arg_0 -> ((Level)level).m_7702_(arg_0)).flatMap(entity -> {
            if (entity instanceof BasePedestalBlockEntity) {
                BasePedestalBlockEntity pedestalEntity = (BasePedestalBlockEntity)((Object)entity);
                return Stream.of(pedestalEntity);
            }
            return Stream.empty();
        }).toList();
        if (ingredientPedestals.size() != allPositions.size()) {
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)modificationBlockPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)modificationParticleBlockPos.m_123341_(), (double)modificationParticleBlockPos.m_123342_(), (double)modificationParticleBlockPos.m_123343_(), new int[]{255, 0, 0}));
            }
            return;
        }
        List<ItemStack> ingredientList = ingredientPedestals.stream().map(BasePedestalBlockEntity::getItemInPedestal).toList();
        MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)inventoryPos, (Direction)this.getPedestalFacing(level, modificationBlockPos), (boolean)true).map(handler -> ItemUpgradeModifications.getFirstSlotWithNonFilteredItems(pedestal, handler).map(slot -> {
            ItemStack singleUpgradeItem = handler.getStackInSlot(slot.intValue()).m_41777_();
            singleUpgradeItem.m_41764_(1);
            int particleRed = 0;
            int particleGreen = 0;
            int particleBlue = 0;
            if (pedestal.addItem(singleUpgradeItem, true)) {
                Optional<UpgradeModificationGlobalRecipe> globalRecipe = this.getModificationGlobalRecipe(level, singleUpgradeItem, ingredientList);
                if (globalRecipe.isPresent() && globalRecipe.get().getResultingModifiedItem(singleUpgradeItem, false) && pedestal.addItem(singleUpgradeItem, false)) {
                    handler.extractItem(slot.intValue(), 1, false);
                    for (int i = 0; i < allPositions.size(); ++i) {
                        BasePedestalBlockEntity ingredientPedestal = (BasePedestalBlockEntity)((Object)((Object)((Object)ingredientPedestals.get(i))));
                        ItemStack toRemove = ((ItemStack)ingredientList.get(i)).m_41777_();
                        if (toRemove.m_41619_()) continue;
                        toRemove.m_41764_(1);
                        ingredientPedestal.removeItemStack(toRemove, false);
                        if (!pedestal.canSpawnParticles()) continue;
                        BlockPos ingredientPedestalParticlePos = this.getPosOfBlockBelow(level, ingredientPedestal.getPos(), -1);
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)ingredientPedestalParticlePos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)ingredientPedestalParticlePos.m_123341_(), (double)ingredientPedestalParticlePos.m_123342_(), (double)ingredientPedestalParticlePos.m_123343_(), new int[]{50, 200, 0}));
                    }
                    particleGreen = 255;
                }
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)modificationParticleBlockPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)modificationParticleBlockPos.m_123341_(), (double)modificationParticleBlockPos.m_123342_(), (double)modificationParticleBlockPos.m_123343_(), new int[]{particleRed, particleGreen, particleBlue}));
                }
            }
            return slot;
        }));
    }
}

