/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseDustBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseEnergyBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseFluidBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseItemBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseXpBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemUpgradePackager
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradePackager(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    public int getMaxItemStacksAllowed() {
        return (Integer)PedestalConfig.COMMON.bulkstorage_maxItemStorage.get();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        Item item;
        ItemStack toPackage;
        boolean dustFull;
        int fluidCapacity = pedestal.getFluidCapacity();
        int energyCapacity = pedestal.getEnergyCapacity();
        int xpCapacity = pedestal.getExperienceCapacity();
        int dustCapacity = pedestal.getDustCapacity();
        boolean fluidFull1 = pedestal.getStoredFluid().getAmount() >= fluidCapacity;
        boolean energyFull1 = pedestal.getStoredEnergy() >= energyCapacity;
        boolean xpFull1 = pedestal.getStoredExperience() >= xpCapacity;
        boolean dustFull1 = pedestal.getStoredDust().getDustAmount() >= dustCapacity;
        FluidStack fluidInPed = pedestal.getStoredFluid().copy();
        int energyInPed = pedestal.getStoredEnergy();
        int xpInPed = pedestal.getStoredExperience();
        DustMagic dustInPed = pedestal.getStoredDust();
        boolean fluidFull = fluidInPed.getAmount() >= fluidCapacity;
        boolean energyFull = energyInPed >= energyCapacity;
        boolean xpFull = xpInPed >= xpCapacity;
        boolean bl = dustFull = dustInPed.getDustAmount() >= dustCapacity;
        if (this.canTransferItems(coin)) {
            IItemHandler handler;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            BlockPos posInventory = this.getPosOfBlockBelow(level, pedestalPos, 1);
            LazyOptional cap = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (!this.isInventoryEmpty((LazyOptional<IItemHandler>)cap) && cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
                ItemStack toPackage2;
                ItemStack stackIn;
                int handlerSize = handler.getSlots();
                for (int i = 0; i < handler.getSlots() && !((stackIn = handler.getStackInSlot(i)).m_41720_() instanceof IBulkItem); ++i) {
                    int maxSizeStack = stackIn.m_41741_();
                    if (stackIn.m_41613_() < maxSizeStack) break;
                    if (i > 0) {
                        if (!this.doItemsMatch((ItemStack)stacks.get(0), stackIn)) break;
                        stacks.add(stackIn);
                        continue;
                    }
                    stacks.add(stackIn);
                }
                if (stacks.size() == handlerSize && pedestal.addItem(toPackage2 = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_ITEM.get()), true)) {
                    ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
                    int maxSlots = handlerSize > this.getMaxItemStacksAllowed() ? this.getMaxItemStacksAllowed() : handlerSize;
                    for (int i = 0; i < maxSlots; ++i) {
                        ItemStack stackIn2 = handler.getStackInSlot(i);
                        if (handler.extractItem(i, stackIn2.m_41613_(), true).m_41619_()) continue;
                        newList.add(stackIn2.m_41777_());
                        handler.extractItem(i, stackIn2.m_41613_(), false);
                    }
                    if (newList.size() > 0) {
                        Item item2 = toPackage2.m_41720_();
                        if (item2 instanceof BaseItemBulkStorageItem) {
                            BaseItemBulkStorageItem bulkItemPackage = (BaseItemBulkStorageItem)item2;
                            bulkItemPackage.setStacksList(toPackage2, newList);
                        }
                        pedestal.addItem(toPackage2, false);
                    }
                }
            }
        }
        if (fluidFull && this.canTransferFluids(coin) && fluidInPed.getAmount() > 0 && !pedestal.removeFluid(fluidInPed.getAmount(), IFluidHandler.FluidAction.SIMULATE).isEmpty() && pedestal.addItem(toPackage = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_FLUID.get()), true)) {
            FluidStack toRemove = pedestal.removeFluid(fluidInPed.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            item = toPackage.m_41720_();
            if (item instanceof BaseFluidBulkStorageItem) {
                BaseFluidBulkStorageItem droppedItemFluid = (BaseFluidBulkStorageItem)item;
                droppedItemFluid.setFluidStack(toPackage, toRemove);
            }
            pedestal.addItem(toPackage, false);
        }
        if (energyFull && this.canTransferEnergy(coin) && energyInPed > 0 && pedestal.removeEnergy(energyInPed, true) > 0 && pedestal.addItem(toPackage = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_ENERGY.get()), true)) {
            int energyToRemove = pedestal.removeEnergy(energyInPed, false);
            item = toPackage.m_41720_();
            if (item instanceof BaseEnergyBulkStorageItem) {
                BaseEnergyBulkStorageItem droppedItemEnergy = (BaseEnergyBulkStorageItem)item;
                droppedItemEnergy.setEnergy(toPackage, energyToRemove);
            }
            pedestal.addItem(toPackage, false);
        }
        if (xpFull && this.canTransferXP(coin) && xpInPed > 0 && pedestal.removeExperience(xpInPed, true) > 0 && pedestal.addItem(toPackage = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_XP.get()), true)) {
            int xpToRemove = pedestal.removeExperience(xpInPed, false);
            item = toPackage.m_41720_();
            if (item instanceof BaseXpBulkStorageItem) {
                BaseXpBulkStorageItem droppedItemXp = (BaseXpBulkStorageItem)item;
                droppedItemXp.setXp(toPackage, xpToRemove);
            }
            pedestal.addItem(toPackage, false);
        }
        if (dustFull && this.canTransferDust(coin) && dustInPed.getDustAmount() > 0 && !pedestal.removeDust(dustInPed, IDustHandler.DustAction.SIMULATE).isEmpty() && pedestal.addItem(toPackage = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_DUST.get()), true)) {
            DustMagic dustToRemove = pedestal.removeDust(dustInPed, IDustHandler.DustAction.EXECUTE);
            item = toPackage.m_41720_();
            if (item instanceof BaseDustBulkStorageItem) {
                BaseDustBulkStorageItem droppedItemDust = (BaseDustBulkStorageItem)item;
                droppedItemDust.setDustMagicInItem(toPackage, dustToRemove);
            }
            pedestal.addItem(toPackage, false);
        }
    }
}

