/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradePlanter
extends ItemUpgradeBase {
    public ItemUpgradePlanter(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyWorkPositionSkip(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_planter_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_planter_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_planter_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_planter_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions(coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal);
        if (allPositions.isEmpty()) {
            return;
        }
        if (this.hasSuperSpeed(pedestal.getCoinOnPedestal())) {
            for (BlockPos plantAtPos : allPositions) {
                this.planterAction(level, pedestal, plantAtPos, !this.hasWorkPositionSkip(pedestal.getCoinOnPedestal()));
            }
        } else {
            int currentPosition = this.getCurrentPosition(pedestal);
            if (this.planterAction(level, pedestal, allPositions.get(currentPosition), !this.hasWorkPositionSkip(pedestal.getCoinOnPedestal()))) {
                if (currentPosition + 1 == allPositions.size()) {
                    this.setCurrentPosition(pedestal, 0);
                } else {
                    this.setCurrentPosition(pedestal, currentPosition + 1);
                }
            }
        }
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, ItemStack toPlant) {
        if (pedestal.hasFilter()) {
            BaseFilter filter;
            ItemStack filterInPedestal = pedestal.getFilterInPedestal();
            Item item = pedestal.getFilterInPedestal().m_41720_();
            if (item instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
                return filter.canAcceptItems(filterInPedestal, toPlant);
            }
        }
        return true;
    }

    private boolean canPlace(Level level, Direction pedestalFacing, BlockPos plantAtPos, ItemStack toPlace) {
        Block possibleBlock = Block.m_49814_((Item)toPlace.m_41720_());
        List cannotPlaceBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_place"))).stream().toList();
        BlockState destinationBlockState = level.m_8055_(pedestalFacing == Direction.DOWN ? plantAtPos.m_7494_() : plantAtPos.m_7495_());
        return possibleBlock != Blocks.f_50016_ && !cannotPlaceBlocks.contains(possibleBlock) && (possibleBlock instanceof IPlantable && destinationBlockState.canSustainPlant((BlockGetter)level, this.getPosBasedOnPedestalFacing(plantAtPos, pedestalFacing), pedestalFacing, (IPlantable)possibleBlock) || possibleBlock instanceof ChorusFlowerBlock && ((ChorusFlowerBlock)possibleBlock).m_7898_(destinationBlockState, (LevelReader)level, plantAtPos) || possibleBlock instanceof GrowingPlantBlock);
    }

    private BlockPos getPosBasedOnPedestalFacing(BlockPos pos, Direction pedestalFacing) {
        return switch (pedestalFacing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> pos.m_7495_();
            case Direction.DOWN -> pos.m_7494_();
            case Direction.NORTH -> pos.m_122019_();
            case Direction.EAST -> pos.m_122024_();
            case Direction.SOUTH -> pos.m_122012_();
            case Direction.WEST -> pos.m_122029_();
        };
    }

    public boolean planterAction(Level level, BasePedestalBlockEntity pedestal, BlockPos targetPos, Boolean skip) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            Direction pedestalFacing = this.getPedestalFacing(level, pedestal.getPos());
            ItemStack toPlant = pedestal.getItemInPedestal().m_41777_();
            toPlant.m_41764_(1);
            if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), targetPos), true) && !pedestal.removeItemStack(toPlant, true).m_41619_() && !targetPos.equals((Object)pedestal.getPos()) && this.passesFilter(pedestal, toPlant)) {
                if (this.canPlace(level, pedestalFacing, targetPos, toPlant)) {
                    UseOnContext blockContext = new UseOnContext(level, (Player)fakePlayer, InteractionHand.MAIN_HAND, toPlant.m_41777_(), new BlockHitResult(Vec3.f_82478_, pedestalFacing, targetPos, false));
                    InteractionResult result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)blockContext);
                    if (result == InteractionResult.CONSUME) {
                        this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), targetPos), false);
                        pedestal.removeItemStack(toPlant, false);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, new int[]{100, 255, 100}));
                        }
                        return true;
                    }
                    return skip;
                }
                return true;
            }
        }
        return false;
    }
}

