/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes.Ingredients;

import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class DustIngredient {
    private static final String KEY_DUST = "dust";
    private static final int COLOR_DEFAULT = -1;
    private static final int AMOUNT_DEFAULT = 0;
    private final DustMagic dustMagic;

    public DustIngredient(int color, int amount) {
        this.dustMagic = new DustMagic(color, amount) == null ? DustMagic.EMPTY : new DustMagic(color, amount);
    }

    public DustIngredient(DustMagic magic) {
        this.dustMagic = magic == null ? DustMagic.EMPTY : magic;
    }

    public DustMagic getDustMagic() {
        return this.dustMagic;
    }

    public boolean hasDust() {
        return !this.dustMagic.isEmpty();
    }

    public static DustIngredient parseData(JsonObject recipeJson) {
        if (!recipeJson.has(KEY_DUST)) {
            return new DustIngredient(-1, 0);
        }
        if (recipeJson.get(KEY_DUST).isJsonObject()) {
            JsonObject dustJson = recipeJson.get(KEY_DUST).getAsJsonObject();
            return new DustIngredient(dustJson.get("dustColor").getAsInt(), dustJson.get("dustAmount").getAsInt());
        }
        return new DustIngredient(-1, 0);
    }

    public List<DustMagic> getMatchingDust() {
        ArrayList<DustMagic> me = new ArrayList<DustMagic>();
        return me;
    }

    public static DustIngredient readFromPacket(FriendlyByteBuf buffer) {
        return new DustIngredient(buffer.readInt(), buffer.readInt());
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.m_130130_(this.dustMagic.getDustColor());
        buf.m_130130_(this.dustMagic.getDustAmount());
    }
}

