/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.apis;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import net.creeperhost.minetogether.com.github.scribejava.apis.salesforce.SalesforceJsonTokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi20;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.TokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessToken;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Verb;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.clientauthentication.RequestBodyAuthenticationScheme;

public class SalesforceApi
extends DefaultApi20 {
    private static final String PRODUCTION_HOST = "login.salesforce.com";
    private static final String SANDBOX_HOST = "test.salesforce.com";
    private static final String PROTOCOL = "https://";
    private static final String ACCESS_PATH = "/services/oauth2/token";
    private static final String AUTHORIZE_PATH = "/services/oauth2/authorize";
    private final String accessTokenUrl;
    private final String authorizationBaseUrl;

    protected SalesforceApi(String hostName) {
        this.accessTokenUrl = PROTOCOL + hostName + ACCESS_PATH;
        this.authorizationBaseUrl = PROTOCOL + hostName + AUTHORIZE_PATH;
        try {
            SSLSocket socket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
            if (!SalesforceApi.isTLSv11orUpperEnabled(socket)) {
                throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
            }
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Salesforce API required to use TLSv1.1 or upper. Enabled it by invoking method initTLSv11orUpper or somehow else");
        }
    }

    public static SalesforceApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static SalesforceApi sandbox() {
        return new SalesforceApi(SANDBOX_HOST);
    }

    @Override
    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @Override
    public String getAccessTokenEndpoint() {
        return this.accessTokenUrl;
    }

    @Override
    protected String getAuthorizationBaseUrl() {
        return this.authorizationBaseUrl;
    }

    @Override
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return SalesforceJsonTokenExtractor.instance();
    }

    private static boolean isTLSv11orUpperEnabled(SSLSocket socket) {
        for (String protocol : socket.getEnabledProtocols()) {
            if (!protocol.startsWith("TLSv1.")) continue;
            return true;
        }
        return false;
    }

    public static void initTLSv11orUpper() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLSocket socket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket();
        if (SalesforceApi.isTLSv11orUpperEnabled(socket)) {
            return;
        }
        Object[] supportedProtocols = socket.getSupportedProtocols();
        Arrays.sort(supportedProtocols);
        for (int i = supportedProtocols.length - 1; i >= 0; --i) {
            Object supportedProtocol = supportedProtocols[i];
            if (!((String)supportedProtocol).startsWith("TLSv1.")) continue;
            SSLContext context = SSLContext.getInstance((String)supportedProtocol);
            context.init(null, null, null);
            SSLContext.setDefault(context);
            return;
        }
        throw new NoSuchAlgorithmException("for Salesforce API to work you need jvm with TLS 1.1 or higher support");
    }

    @Override
    public ClientAuthentication getClientAuthentication() {
        return RequestBodyAuthenticationScheme.instance();
    }

    private static class InstanceHolder {
        private static final SalesforceApi INSTANCE = new SalesforceApi("login.salesforce.com");

        private InstanceHolder() {
        }
    }
}

