/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.extractors;

import java.io.IOException;
import java.net.URI;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.JsonNode;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.ObjectMapper;
import net.creeperhost.minetogether.com.github.scribejava.core.exceptions.OAuthException;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.TokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessToken;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Response;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.OAuth2Error;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public class OAuth2AccessTokenJsonExtractor
implements TokenExtractor<OAuth2AccessToken> {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected OAuth2AccessTokenJsonExtractor() {
    }

    public static OAuth2AccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(Response response) throws IOException {
        String body = response.getBody();
        Preconditions.checkEmptyString(body, "Response body is incorrect. Can't extract a token from an empty string");
        if (response.getCode() != 200) {
            this.generateError(body);
        }
        return this.createToken(body);
    }

    public void generateError(String rawResponse) throws IOException {
        OAuth2Error errorCode;
        URI errorUri;
        JsonNode response = OBJECT_MAPPER.readTree(rawResponse);
        JsonNode errorUriInString = response.get("error_uri");
        try {
            errorUri = errorUriInString == null ? null : URI.create(errorUriInString.asText());
        }
        catch (IllegalArgumentException iae) {
            errorUri = null;
        }
        try {
            errorCode = OAuth2Error.parseFrom(OAuth2AccessTokenJsonExtractor.extractRequiredParameter(response, "error", rawResponse).asText());
        }
        catch (IllegalArgumentException iaE) {
            errorCode = null;
        }
        JsonNode errorDescription = response.get("error_description");
        throw new OAuth2AccessTokenErrorResponse(errorCode, errorDescription == null ? null : errorDescription.asText(), errorUri, rawResponse);
    }

    private OAuth2AccessToken createToken(String rawResponse) throws IOException {
        JsonNode response = OBJECT_MAPPER.readTree(rawResponse);
        JsonNode expiresInNode = response.get("expires_in");
        JsonNode refreshToken = response.get("refresh_token");
        JsonNode scope = response.get("scope");
        JsonNode tokenType = response.get("token_type");
        return this.createToken(OAuth2AccessTokenJsonExtractor.extractRequiredParameter(response, "access_token", rawResponse).asText(), tokenType == null ? null : tokenType.asText(), expiresInNode == null ? null : Integer.valueOf(expiresInNode.asInt()), refreshToken == null ? null : refreshToken.asText(), scope == null ? null : scope.asText(), response, rawResponse);
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, JsonNode response, String rawResponse) {
        return new OAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, rawResponse);
    }

    protected static JsonNode extractRequiredParameter(JsonNode errorNode, String parameterName, String rawResponse) throws OAuthException {
        JsonNode value = errorNode.get(parameterName);
        if (value == null) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + parameterName + "' from this: '" + rawResponse + "'", null);
        }
        return value;
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenJsonExtractor INSTANCE = new OAuth2AccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

