/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.services;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import net.creeperhost.minetogether.com.github.scribejava.core.exceptions.OAuthSignatureException;
import net.creeperhost.minetogether.com.github.scribejava.core.services.SignatureService;

public class RSASha1SignatureService
implements SignatureService {
    private static final String METHOD = "RSA-SHA1";
    private static final String RSA_SHA1 = "SHA1withRSA";
    private static final String UTF8 = "UTF-8";
    private final PrivateKey privateKey;

    public RSASha1SignatureService(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Signature signature = Signature.getInstance(RSA_SHA1);
            signature.initSign(this.privateKey);
            signature.update(baseString.getBytes(UTF8));
            return BASE_64_ENCODER.encodeToString(signature.sign());
        }
        catch (UnsupportedEncodingException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

