/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.PacketHandler;
import net.creeperhost.minetogether.connect.lib.netty.packet.Ping;
import net.creeperhost.minetogether.connect.lib.netty.packet.Pong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChannelHandler<H extends PacketHandler>
extends SimpleChannelInboundHandler<Packet<H>>
implements PacketHandler {
    private final Logger LOGGER = LogManager.getLogger();
    private int pingSeq = 0;
    @Nullable
    private ScheduledFuture<?> pingFuture;
    protected long lastPingSent;
    protected long lastPongRecv;
    protected long lastPingRecv;
    protected Channel channel;

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channel = ctx.channel();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        if (this.pingFuture != null) {
            this.pingFuture.cancel(false);
        }
        super.channelInactive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.pingFuture != null) {
            this.pingFuture.cancel(false);
        }
        super.handlerRemoved(ctx);
    }

    protected final ChannelFuture sendPacket(Packet<?> packet) {
        assert (this.channel != null) : "Not connected.";
        return this.channel.writeAndFlush(packet).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    protected final ChannelFuture sendAndClose(Packet<?> packet) {
        assert (this.channel != null) : "Not connected.";
        return this.channel.writeAndFlush(packet).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void configureKeepAlivePing() {
        this.LOGGER.info("Enabling keepalive pings for {}", (Object)this.channel.remoteAddress());
        this.pingFuture = this.channel.eventLoop().scheduleWithFixedDelay(this::sendKeepAlivePing, 0L, 30L, TimeUnit.SECONDS);
    }

    public final void sendKeepAlivePing() {
        try {
            this.lastPingSent = System.nanoTime();
            this.sendPacket(new Ping(++this.pingSeq));
        }
        catch (Throwable ex) {
            this.LOGGER.error("Error sending ping packet.", ex);
        }
    }

    @Override
    public final void handlePing(ChannelHandlerContext ctx, Ping ping) {
        this.sendPacket(new Pong(ping.seq));
        this.lastPingRecv = System.nanoTime();
    }

    @Override
    public final void handlePong(ChannelHandlerContext ctx, Pong pong) {
        this.lastPongRecv = System.nanoTime();
        int diff = pong.seq - this.pingSeq;
        if (diff > 0) {
            this.LOGGER.error("Ping sequence larger than expected?");
        } else if (diff < 0) {
            this.LOGGER.warn("High latency, got ping seq {}, expected {}.", (Object)pong.seq, (Object)this.pingSeq);
        }
    }
}

