/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.packet.MeshPacketHandler;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;

public final class MHostUpdate
implements Packet<MeshPacketHandler> {
    public final Map<String, String> newHosts;
    public final Set<String> deadHosts;

    public MHostUpdate(Map<String, String> newHosts, Set<String> deadHosts) {
        this.newHosts = newHosts;
        this.deadHosts = deadHosts;
    }

    public MHostUpdate(PacketCtx ctx) {
        int nNewHosts = DataUtils.readVarInt(ctx.buf);
        this.newHosts = new HashMap<String, String>(nNewHosts);
        for (int i = 0; i < nNewHosts; ++i) {
            this.newHosts.put(DataUtils.readString(ctx.buf), DataUtils.readString(ctx.buf));
        }
        int nDeadHosts = DataUtils.readVarInt(ctx.buf);
        this.deadHosts = new HashSet<String>(nDeadHosts);
        for (int i = 0; i < nDeadHosts; ++i) {
            this.deadHosts.add(DataUtils.readString(ctx.buf));
        }
    }

    @Override
    public void write(ByteBuf buf) {
        DataUtils.writeVarInt(buf, this.newHosts.size());
        this.newHosts.forEach((k, v) -> {
            DataUtils.writeString(buf, k);
            DataUtils.writeString(buf, v);
        });
        DataUtils.writeVarInt(buf, this.deadHosts.size());
        this.deadHosts.forEach(e -> DataUtils.writeString(buf, e));
    }

    @Override
    public void handle(ChannelHandlerContext ctx, MeshPacketHandler handler) throws Exception {
        handler.handleHostUpdate(ctx, this);
    }
}

