/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.ServerPacketHandler;

public final class SHostConnect
implements Packet<ServerPacketHandler> {
    public final String sessionToken;
    public final String linkToken;

    public SHostConnect(String sessionToken, String linkToken) {
        this.sessionToken = sessionToken;
        this.linkToken = linkToken;
    }

    public SHostConnect(PacketCtx ctx) {
        this.sessionToken = DataUtils.readString(ctx.buf);
        this.linkToken = DataUtils.readString(ctx.buf);
    }

    @Override
    public void write(ByteBuf buf) {
        DataUtils.writeString(buf, this.sessionToken);
        DataUtils.writeString(buf, this.linkToken);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, ServerPacketHandler handler) throws Exception {
        handler.handleHostConnect(ctx, this);
    }
}

