/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.dialogs;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSelectDialog<E>
extends GuiElement<ItemSelectDialog<E>>
implements BackgroundRender {
    private final GuiTextField searchField;
    private final GuiList<E> itemList;
    private boolean blockOutsideClicks = false;
    private boolean closeOnOutsideClick = false;
    @Nullable
    private Consumer<E> onItemSelected;
    private final List<E> items;
    private E selected;

    public ItemSelectDialog(@NotNull GuiParent<?> parent, Component title, List<E> items) {
        this(parent, title, items, null);
    }

    public ItemSelectDialog(@NotNull GuiParent<?> parent, Component title, List<E> items, E defaultItem) {
        this(parent, title, items, defaultItem, e -> Component.m_237113_((String)String.valueOf(e)));
    }

    public ItemSelectDialog(@NotNull GuiParent<?> parent, Component title, List<E> items, E defaultItem, Function<E, Component> toComponentFunction) {
        super(parent);
        this.items = items;
        this.selected = defaultItem;
        this.setOpaque(true);
        GuiText titleText = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, title).setWrap(true).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.font().m_239133_((FormattedText)title, (int)this.xSize() - 10)));
        GuiButton select = (GuiButton)((GuiButton)((GuiButton)((GuiButton)ItemSelectDialog.button(this, (Component)Component.m_237115_((String)"minetogether:gui.select_dialog.select")).setDisabled(() -> this.selected == null).onPress(this::accept).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.midPoint((GeoRef)this.get(GeoParam.LEFT), (GeoRef)this.get(GeoParam.RIGHT), (double)-1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiButton cancel = (GuiButton)((GuiButton)((GuiButton)((GuiButton)ItemSelectDialog.button(this, (Component)Component.m_237115_((String)"minetogether:gui.select_dialog.cancel")).onPress(this::close).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)this.get(GeoParam.LEFT), (GeoRef)this.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle searchBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)this).fill(-1608507360).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)select.get(GeoParam.TOP), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        this.searchField = new GuiTextField((GuiParent)searchBg).setTextState(TextState.simpleState((String)"", s -> this.reloadItems())).setSuggestion((Component)Component.m_237115_((String)"minetogether:gui.select_dialog.search"));
        Constraints.bind((ConstrainedGeometry)this.searchField, (ConstrainedGeometry)searchBg, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        GuiRectangle listBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)this).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)titleText.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)searchBg.get(GeoParam.TOP), (double)-2.0));
        this.itemList = new GuiList((GuiParent)this).addHiddenScrollBar().setItemSpacing(1.0);
        Constraints.bind(this.itemList, (ConstrainedGeometry)listBg, (double)0.0);
        this.itemList.setDisplayBuilder((list, item) -> {
            Component text = (Component)toComponentFunction.apply(item);
            GuiButton button = GuiButton.flatColourButton((GuiParent)list, null, highlight -> highlight != false ? -1602191232 : -1608507360).setToggleMode(() -> item.equals(this.selected)).onPress(() -> this.selectItem(item));
            button.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> (double)this.font().m_239133_((FormattedText)text, (int)button.xSize() - 4) + 2.0));
            GuiText display = new GuiText((GuiParent)button, text).setWrap(true);
            Constraints.bind((ConstrainedGeometry)display, (ConstrainedGeometry)button, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
            return button;
        });
        ModularGui gui = this.getModularGui();
        this.constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)gui.get(GeoParam.TOP), (GeoRef)gui.get(GeoParam.BOTTOM), (double)-100.0));
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)gui.get(GeoParam.LEFT), (GeoRef)gui.get(GeoParam.RIGHT), (double)-75.0));
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)200.0));
        this.reloadItems();
    }

    public GuiList<E> getItemList() {
        return this.itemList;
    }

    public void reloadItems() {
        this.itemList.getList().clear();
        String search = this.searchField.getValue();
        for (E item : this.items) {
            if (!search.isEmpty() && !String.valueOf(item).toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            this.itemList.add(item);
        }
        this.itemList.markDirty();
        if (this.selected != null) {
            this.itemList.scrollTo(this.selected);
        }
    }

    public static GuiButton button(GuiElement<?> parent, Component label) {
        GuiButton button = new GuiButton(parent);
        GuiRectangle background = new GuiRectangle((GuiParent)button).fill(() -> button.isDisabled() ? -2011160544 : (button.isMouseOver() || button.toggleState() || button.isPressed() ? -7303024 : -11513776));
        Constraints.bind((ConstrainedGeometry)background, (ConstrainedGeometry)button);
        GuiText text = new GuiText((GuiParent)button, label);
        button.setLabel(text);
        Constraints.bind((ConstrainedGeometry)text, (ConstrainedGeometry)button, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return button;
    }

    public ItemSelectDialog<E> setBlockOutsideClicks(boolean blockOutsideClicks) {
        this.blockOutsideClicks = blockOutsideClicks;
        return this;
    }

    public ItemSelectDialog<E> setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public ItemSelectDialog<E> setOnItemSelected(Consumer<E> onItemSelected) {
        this.onItemSelected = onItemSelected;
        return this;
    }

    public void selectItem(E item) {
        if (item != null && item.equals(this.selected)) {
            this.accept();
        }
        this.selected = item;
    }

    public void accept() {
        if (this.onItemSelected != null && this.selected != null) {
            this.onItemSelected.accept(this.selected);
        }
        this.close();
    }

    public void close() {
        this.getParent().removeChild((GuiElement)this);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.closeOnOutsideClick && !this.getRectangle().contains(mouseX, mouseY)) {
            this.close();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button, consumed) || this.blockOutsideClicks;
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 256) {
            this.close();
        }
        return true;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), -15728624, -11534081, -14155649);
    }
}

