/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.minetogether.lib.chat.util.HashLength;
import net.creeperhost.minetogether.repack.net.covers1624.quack.gson.JsonUtils;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.VisibleForTesting;

public class MutedUserList {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type STRING_SET = new TypeToken<Set<String>>(){}.getType();
    private final Path file;
    private final Set<String> mutedUsers;

    @VisibleForTesting
    protected MutedUserList(Path file, Set<String> mutedUsers) {
        this.file = file;
        this.mutedUsers = mutedUsers;
    }

    public MutedUserList(Path file) {
        Set<String> mu;
        this.file = file;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                mu = (Set)JsonUtils.parse(GSON, file, STRING_SET);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load MutedUsers list!", (Throwable)ex);
                mu = new HashSet();
            }
        } else {
            mu = new HashSet<String>();
        }
        this.mutedUsers = mu;
        this.mutedUsers.remove(null);
        this.save();
    }

    public boolean isUserMuted(String hash) {
        assert (HashLength.FULL.matches(hash));
        return this.mutedUsers.contains(hash);
    }

    public void muteUser(String hash) {
        assert (HashLength.FULL.matches(hash));
        if (this.mutedUsers.add(hash)) {
            this.save();
        }
    }

    public void unmuteUser(String hash) {
        assert (HashLength.FULL.matches(hash));
        if (this.mutedUsers.remove(hash)) {
            this.save();
        }
    }

    public Iterable<String> getMutedUsers() {
        return Collections.unmodifiableSet(this.mutedUsers);
    }

    @VisibleForTesting
    protected void save() {
        try {
            JsonUtils.write(GSON, IOUtils.makeParents(this.file), this.mutedUsers);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to save MutedUsers list!", (Throwable)ex);
        }
    }
}

