/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.message;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.StreamableIterable;
import org.apache.commons.lang3.tuple.Pair;

public class MessageUtils {
    private static final Pattern MT_USER_REGEX = Pattern.compile("(MT[\\dA-Fa-f]{15,28})");
    private static final String FALLBACK_SYSTEM_USER = "System";
    private static final Pattern SYSTEM_USER_REGEX = Pattern.compile("^(\\w+?):");
    private static final Pattern DISCORD_USER_REGEX = Pattern.compile("^Discord<(MT[\\dA-Fa-f]{15,28})>:");

    public static MessageComponent parseMessage(ProfileManager profileManager, String message) {
        Matcher matcher = MT_USER_REGEX.matcher(message);
        MessageComponent result = MessageComponent.of();
        int lastEnd = -1;
        while (matcher.find()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            String hash = message.substring(start, end);
            result = result.append(message.substring(lastEnd != -1 ? lastEnd : 0, start));
            lastEnd = end;
            result = result.append(profileManager.lookupProfile(hash));
        }
        if (lastEnd != -1 && lastEnd < message.length()) {
            result = result.append(message.substring(lastEnd));
        }
        if (result.isEmpty()) {
            return MessageComponent.of(message);
        }
        return result;
    }

    public static Pair<MessageComponent, MessageComponent> parseSystemMessage(ProfileManager profileManager, String message) {
        MessageComponent parsedSender = MessageComponent.of(FALLBACK_SYSTEM_USER);
        Matcher matcher = DISCORD_USER_REGEX.matcher(message);
        if (matcher.find()) {
            parsedSender = MessageComponent.of(profileManager.lookupProfile(matcher.group(1)));
            message = message.substring(matcher.end(0) + 1);
        } else {
            matcher = SYSTEM_USER_REGEX.matcher(message);
            if (matcher.find()) {
                parsedSender = MessageComponent.of(matcher.group(1));
                message = message.substring(matcher.end(0) + 1);
            }
        }
        return Pair.of((Object)parsedSender, (Object)MessageUtils.parseMessage(profileManager, message));
    }

    public static String processOutboundMessage(ProfileManager profileManager, String message) {
        message = message.replaceAll("(\u00a7.)", "");
        HashMap<String, String> knownUsers = StreamableIterable.of(profileManager.getKnownProfiles()).filter(e -> e.getIrcName() != null).toMap(Profile::getDisplayName, Profile::getIrcName);
        for (Map.Entry entry : knownUsers.entrySet()) {
            message = message.replaceAll((String)entry.getKey(), "MT" + (String)entry.getValue());
        }
        return message;
    }
}

