/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import net.creeperhost.minetogether.lib.util.WeakListener;
import net.creeperhost.minetogether.lib.util.WeakNotifiable;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;

public class AbstractWeakNotifiable<T>
implements WeakNotifiable<T> {
    private final LinkedList<Entry> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <W> Object addListener(W watch, WeakListener<W, T> listener) {
        LinkedList<Entry> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(new Entry(new SoftReference<W>(watch), listener));
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object key) {
        LinkedList<Entry> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.removeIf(e -> e.listener == key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fire(T thing) {
        LinkedList<Entry> linkedList = this.listeners;
        synchronized (linkedList) {
            Iterator itr = this.listeners.iterator();
            while (itr.hasNext()) {
                Entry entry = (Entry)itr.next();
                Object watch = entry.watch.get();
                if (watch == null) {
                    itr.remove();
                    continue;
                }
                entry.listener.fire(SneakyUtils.unsafeCast(watch), thing);
            }
        }
    }

    private class Entry {
        public final SoftReference<Object> watch;
        public final WeakListener<?, T> listener;

        private Entry(SoftReference<Object> watch, WeakListener<?, T> listener) {
            this.watch = watch;
            this.listener = listener;
        }
    }
}

