/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.elements;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.dialogs.ItemSelectDialog;
import net.creeperhost.minetogether.orderform.OrderGui;
import net.creeperhost.minetogether.orderform.WorldUploader;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiDialog;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.NotNull;

public class WorldElement
extends GuiElement<WorldElement> {
    private final OrderGui gui;
    public String worldName = "";
    public WorldUploader worldUploader = null;

    public WorldElement(@NotNull GuiParent<?> parent, OrderGui gui) {
        super(parent);
        this.gui = gui;
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237115_((String)"minetogether:gui.order.world").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        MutableComponent worldInfo = Component.m_237115_((String)"minetogether:gui.order.world.info").m_130940_(ChatFormatting.GRAY);
        lastElement = (GuiElement)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)worldInfo).setWrap(true).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)));
        lastElement.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.lambda$new$0((Component)worldInfo)));
        List<LevelSummary> levels = this.loadLevels(this.mc());
        if (levels.isEmpty()) {
            MutableComponent noWorlds = Component.m_237115_((String)"minetogether:gui.order.world.no_worlds").m_130940_(ChatFormatting.RED);
            lastElement = (GuiElement)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)noWorlds).setWrap(true).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)));
            lastElement.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.lambda$new$1((Component)noWorlds)));
        } else {
            lastElement = (GuiElement)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, () -> this.worldUploader != null && this.worldUploader.errored() ? Component.m_237113_((String)this.worldUploader.getError()).m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"minetogether:gui.order.world.select")).setDisabled(() -> this.worldUploader != null || !StringUtil.m_14408_((String)gui.order.worldUrl)).onPress(() -> new ItemSelectDialog<LevelSummary>((GuiParent<?>)this.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:gui.order.world.select"), levels, (LevelSummary)levels.get(0), e -> Component.m_237119_().m_7220_((Component)Component.m_237113_((String)e.m_78361_()).m_130940_(ChatFormatting.GREEN)).m_130946_("\n").m_7220_(e.m_78376_()).m_130940_(ChatFormatting.GRAY)).setCloseOnOutsideClick(true).setOnItemSelected(selected -> {
                Path worldFolder = this.mc().m_91392_().m_78257_().resolve(selected.m_78358_());
                GuiDialog.optionsDialog((GuiParent)this, (Component)Component.m_237110_((String)"minetogether:gui.order.confirm_upload", (Object[])new Object[]{Component.m_237113_((String)selected.m_78361_()).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.BLUE), (Component)Component.m_237115_((String)"minetogether:gui.order.confirm_upload.info").m_130940_(ChatFormatting.GRAY), (int)250, (GuiDialog.Option[])new GuiDialog.Option[]{GuiDialog.primary((Component)Component.m_237115_((String)"minetogether:gui.order.world.upload"), () -> this.startWorldUpload(worldFolder, (LevelSummary)selected)), GuiDialog.caution((Component)Component.m_237115_((String)"gui.cancel"), () -> {})});
            })).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
            lastElement = (GuiElement)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonCaution(this, this::cancelWorldText).setDisabled(() -> this.worldUploader == null && StringUtil.m_14408_((String)gui.order.worldUrl)).onPress(this::cancelWorldAction).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)60.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
            ((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, this::worldBtnLeft).setDisabled(() -> this.worldUploader == null || !this.worldUploader.errored()).onPress(this::worldBtnLeftAction).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        }
        this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.BOTTOM)));
    }

    private Component worldBtnLeft() {
        if (!StringUtil.m_14408_((String)this.gui.order.worldUrl)) {
            return Component.m_237110_((String)"minetogether:gui.order.world.upload_complete", (Object[])new Object[]{this.worldName}).m_130940_(ChatFormatting.GREEN);
        }
        if (this.worldUploader != null) {
            if (this.worldUploader.errored()) {
                return Component.m_237115_((String)"minetogether:gui.order.world.retry");
            }
            return this.worldUploader.getStatus();
        }
        return Component.m_237119_();
    }

    private void worldBtnLeftAction() {
        if (!StringUtil.m_14408_((String)this.gui.order.worldUrl)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.gui.order.worldUrl);
        } else if (this.worldUploader != null && this.worldUploader.errored()) {
            this.worldUploader.start();
        }
    }

    private Component cancelWorldText() {
        if (!StringUtil.m_14408_((String)this.gui.order.worldUrl)) {
            return Component.m_237115_((String)"minetogether:gui.order.world.remove");
        }
        if (this.worldUploader != null) {
            return Component.m_237115_((String)"gui.cancel");
        }
        return Component.m_237119_();
    }

    private void cancelWorldAction() {
        if (!StringUtil.m_14408_((String)this.gui.order.worldUrl)) {
            this.gui.order.worldUrl = "";
        } else if (this.worldUploader != null) {
            this.worldUploader.cancel();
            this.worldUploader = null;
        }
    }

    private List<LevelSummary> loadLevels(Minecraft minecraft) {
        LevelStorageSource.LevelCandidates candidates;
        try {
            candidates = minecraft.m_91392_().m_230833_();
        }
        catch (LevelStorageException e2) {
            OrderGui.LOGGER.error("Couldn't load level list", (Throwable)e2);
            return Collections.emptyList();
        }
        if (candidates.m_230843_()) {
            return Collections.emptyList();
        }
        try {
            return (List)((CompletableFuture)minecraft.m_91392_().m_230813_(candidates).exceptionally(e -> {
                OrderGui.LOGGER.error("Couldn't load level list", e);
                return List.of();
            })).get();
        }
        catch (InterruptedException | ExecutionException e3) {
            OrderGui.LOGGER.error("Couldn't load level list", (Throwable)e3);
            return Collections.emptyList();
        }
    }

    private void startWorldUpload(Path worldFolder, LevelSummary summary) {
        if (this.worldUploader != null) {
            return;
        }
        this.worldName = summary.m_78361_();
        this.worldUploader = new WorldUploader(worldFolder);
        this.worldUploader.start();
    }

    private /* synthetic */ Double lambda$new$1(Component noWorlds) {
        return this.font().m_239133_((FormattedText)noWorlds, (int)this.xMax() - (int)this.xMin());
    }

    private /* synthetic */ Double lambda$new$0(Component worldInfo) {
        return this.font().m_239133_((FormattedText)worldInfo, (int)this.xMax() - (int)this.xMin());
    }
}

