/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class TimeUtils {
    public static final SimpleDateFormat FORMAT_RFC1123 = TimeUtils.parseFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    public static final SimpleDateFormat FORMAT_RFC1036 = TimeUtils.parseFormat("EEE, dd-MMM-yy HH:mm:ss zzz");
    public static final SimpleDateFormat FORMAT_ASCTIME = TimeUtils.parseFormat("EEE MMM d HH:mm:ss yyyy");
    protected static final SimpleDateFormat[] PATTERNS = new SimpleDateFormat[]{FORMAT_RFC1123, FORMAT_RFC1036, FORMAT_ASCTIME};
    private static final Date TWO_DIGIT_YEAR_START;

    @Nullable
    public static Date parseDate(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1 && str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        for (SimpleDateFormat pattern : PATTERNS) {
            pattern.set2DigitYearStart(TWO_DIGIT_YEAR_START);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = pattern.parse(str, parsePosition);
            if (parsePosition.getIndex() == 0) continue;
            return date;
        }
        return null;
    }

    private static SimpleDateFormat parseFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(2000, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        TWO_DIGIT_YEAR_START = cal.getTime();
    }
}

