/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;

public final class Colors {
    public static final String NORMAL = "\u000f";
    public static final String BOLD = "\u0002";
    public static final String UNDERLINE = "\u001f";
    public static final String REVERSE = "\u0016";
    public static final String WHITE = "\u000300";
    public static final String BLACK = "\u000301";
    public static final String DARK_BLUE = "\u000302";
    public static final String DARK_GREEN = "\u000303";
    public static final String RED = "\u000304";
    public static final String BROWN = "\u000305";
    public static final String PURPLE = "\u000306";
    public static final String OLIVE = "\u000307";
    public static final String YELLOW = "\u000308";
    public static final String GREEN = "\u000309";
    public static final String TEAL = "\u000310";
    public static final String CYAN = "\u000311";
    public static final String BLUE = "\u000312";
    public static final String MAGENTA = "\u000313";
    public static final String DARK_GRAY = "\u000314";
    public static final String LIGHT_GRAY = "\u000315";
    public static final String ITALICS = "\u001d";
    public static final ImmutableMap<String, String> COLORS_TABLE = ImmutableMap.builder().put((Object)"WHITE", (Object)"\u000300").put((Object)"BLACK", (Object)"\u000301").put((Object)"DARK_BLUE", (Object)"\u000302").put((Object)"DARK_GREEN", (Object)"\u000303").put((Object)"RED", (Object)"\u000304").put((Object)"BROWN", (Object)"\u000305").put((Object)"PURPLE", (Object)"\u000306").put((Object)"OLIVE", (Object)"\u000307").put((Object)"YELLOW", (Object)"\u000308").put((Object)"GREEN", (Object)"\u000309").put((Object)"TEAL", (Object)"\u000310").put((Object)"CYAN", (Object)"\u000311").put((Object)"BLUE", (Object)"\u000312").put((Object)"MAGENTA", (Object)"\u000313").put((Object)"DARK_GRAY", (Object)"\u000314").put((Object)"LIGHT_GRAY", (Object)"\u000315").build();
    public static final ImmutableMap<String, String> FORMATTING_TABLE = ImmutableMap.builder().put((Object)"NORMAL", (Object)"\u000f").put((Object)"BOLD", (Object)"\u0002").put((Object)"UNDERLINE", (Object)"\u001f").put((Object)"REVERSE", (Object)"\u0016").put((Object)"ITALICS", (Object)"\u001d").build();
    public static final ImmutableMap<String, String> LOOKUP_TABLE = ImmutableMap.builder().putAll(COLORS_TABLE).putAll(FORMATTING_TABLE).build();

    private Colors() {
    }

    public static String lookup(String colorName) {
        return (String)LOOKUP_TABLE.get((Object)colorName.toUpperCase());
    }

    public static String bg(String foreground, String background) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)foreground), (Object)"foreground");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)background), (Object)"background");
        return foreground + "," + background.replace("\u0003", "");
    }

    public static String set(String message, String foregroundColor) {
        return foregroundColor + message + NORMAL;
    }

    public static String set(String message, String foregroundColor, String backgroundColor) {
        return Colors.bg(foregroundColor, backgroundColor) + message + NORMAL;
    }

    public static String removeColors(String line) {
        int length = line.length();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < length) {
            char ch = line.charAt(i);
            if (ch == '\u0003') {
                if (++i >= length || !Character.isDigit(ch = line.charAt(i))) continue;
                if (++i < length && Character.isDigit(ch = line.charAt(i))) {
                    ++i;
                }
                if (i >= length || (ch = line.charAt(i)) != ',') continue;
                if (++i < length) {
                    ch = line.charAt(i);
                    if (Character.isDigit(ch)) {
                        if (++i >= length || !Character.isDigit(ch = line.charAt(i))) continue;
                        ++i;
                        continue;
                    }
                    --i;
                    continue;
                }
                --i;
                continue;
            }
            if (ch == '\u000f') {
                ++i;
                continue;
            }
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static String removeFormatting(String line) {
        int length = line.length();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            if (ch == '\u000f' || ch == '\u0002' || ch == '\u001f' || ch == '\u0016' || ch == '\u001d') continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String removeFormattingAndColors(String line) {
        return Colors.removeFormatting(Colors.removeColors(line));
    }
}

