/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.Configuration;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserChannelMap;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.UserLevel;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.DaoException;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.ChannelSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserChannelDaoSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserChannelMapSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserSnapshot;
import net.creeperhost.minetogether.repack.org.pircbotx.tools.ConcurrentEnumMap;
import org.apache.commons.lang3.StringUtils;

public class UserChannelDao<U extends User, C extends Channel>
implements Closeable {
    protected final PircBotX bot;
    protected final Configuration.BotFactory botFactory;
    protected final Locale locale;
    protected final Object accessLock = new Object();
    protected final UserChannelMap<U, C> mainMap;
    protected final Map<UserLevel, UserChannelMap<U, C>> levelsMap;
    protected final Map<String, U> userNickMap;
    protected final Map<String, C> channelNameMap;
    private final ReentrantReadWriteLock reentlock = new ReentrantReadWriteLock();
    private final Lock rL = this.reentlock.readLock();
    private final Lock wL = this.reentlock.writeLock();

    protected UserChannelDao(PircBotX bot, Configuration.BotFactory botFactory) {
        this.bot = bot;
        this.botFactory = botFactory;
        this.locale = bot.getConfiguration().getLocale();
        this.mainMap = new UserChannelMap();
        this.userNickMap = new HashMap<String, U>();
        this.channelNameMap = new HashMap<String, C>();
        this.levelsMap = new ConcurrentEnumMap<UserLevel, UserChannelMap<U, C>>(UserLevel.class);
        for (UserLevel level : UserLevel.values()) {
            this.levelsMap.put(level, new UserChannelMap());
        }
    }

    public U getUser(@NonNull String nick) throws DaoException {
        if (nick == null) {
            throw new NullPointerException("nick is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)nick), (Object)"Cannot get a blank user");
        String nickLowercase = nick.toLowerCase(this.locale);
        this.rL.lock();
        try {
            User user = (User)this.userNickMap.get(nickLowercase);
            if (user != null) {
                User user2 = user;
                return (U)user2;
            }
            throw new DaoException(DaoException.Reason.UNKNOWN_USER, nick);
        }
        finally {
            this.rL.unlock();
        }
    }

    public U getUser(@NonNull UserHostmask userHostmask) {
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        this.rL.lock();
        try {
            if (userHostmask.getNick() == null) {
                U u = this.getUser(userHostmask.getHostmask());
                return u;
            }
            U u = this.getUser(userHostmask.getNick());
            return u;
        }
        catch (Exception e) {
            throw new DaoException(DaoException.Reason.UNKNOWN_USER_HOSTMASK, userHostmask.toString(), e);
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public U createUser(@NonNull UserHostmask userHostmask) {
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        String nickLowercase = userHostmask.getNick().toLowerCase(this.locale);
        this.wL.lock();
        try {
            if (this.containsUser(userHostmask)) {
                throw new RuntimeException("Cannot create a user from hostmask that already exists: " + userHostmask);
            }
            User user = this.botFactory.createUser(userHostmask);
            this.userNickMap.put(nickLowercase, user);
            User user2 = user;
            return (U)user2;
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUser(@NonNull String nick) {
        if (nick == null) {
            throw new NullPointerException("nick is marked non-null but is null");
        }
        String nickLowercase = nick.toLowerCase(this.locale);
        this.rL.lock();
        try {
            boolean bl = this.userNickMap.containsKey(nickLowercase);
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    public boolean containsUser(@NonNull UserHostmask hostmask) {
        if (hostmask == null) {
            throw new NullPointerException("hostmask is marked non-null but is null");
        }
        this.rL.lock();
        try {
            boolean bl = this.containsUser(hostmask.getNick());
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    public ImmutableSortedSet<U> getAllUsers() {
        this.rL.lock();
        try {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(this.userNickMap.values());
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserToChannel(@NonNull U user, @NonNull C channel) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.wL.lock();
        try {
            if (!this.containsUser((UserHostmask)user)) {
                String nickLowercase = ((UserHostmask)user).getNick().toLowerCase(this.locale);
                this.userNickMap.put(nickLowercase, user);
            }
            this.mainMap.addUserToChannel(user, channel);
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserToLevel(@NonNull UserLevel level, @NonNull U user, @NonNull C channel) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.wL.lock();
        try {
            this.levelsMap.get((Object)level).addUserToChannel(user, channel);
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserFromLevel(@NonNull UserLevel level, @NonNull U user, @NonNull C channel) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.wL.lock();
        try {
            this.levelsMap.get((Object)level).removeUserFromChannel(user, channel);
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<U> getNormalUsers(@NonNull C channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.rL.lock();
        try {
            HashSet<U> remainingUsers = new HashSet<U>(this.mainMap.getUsers(channel));
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                remainingUsers.removeAll((Collection<?>)curLevelMap.getUsers(channel));
            }
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(remainingUsers);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<U> getUsers(@NonNull C channel, @NonNull UserLevel level) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        this.rL.lock();
        try {
            ImmutableSortedSet<U> immutableSortedSet = this.levelsMap.get((Object)level).getUsers(channel);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<UserLevel> getLevels(@NonNull C channel, @NonNull U user) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.rL.lock();
        try {
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            for (Map.Entry<UserLevel, UserChannelMap<U, C>> curEntry : this.levelsMap.entrySet()) {
                if (!curEntry.getValue().containsEntry(user, channel)) continue;
                builder.add((Object)curEntry.getKey());
            }
            ImmutableSortedSet immutableSortedSet = builder.build();
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<C> getNormalUserChannels(@NonNull U user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.rL.lock();
        try {
            HashSet<C> remainingChannels = new HashSet<C>(this.mainMap.getChannels(user));
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                remainingChannels.removeAll((Collection<?>)curLevelMap.getChannels(user));
            }
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(remainingChannels);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<C> getChannels(@NonNull U user, @NonNull UserLevel level) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        this.rL.lock();
        try {
            ImmutableSortedSet<C> immutableSortedSet = this.levelsMap.get((Object)level).getChannels(user);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserFromChannel(@NonNull U user, @NonNull C channel) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        String nickLowercase = ((UserHostmask)user).getNick().toLowerCase(this.locale);
        this.wL.lock();
        try {
            this.mainMap.removeUserFromChannel(user, channel);
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                curLevelMap.removeUserFromChannel(user, channel);
            }
            if (!this.mainMap.containsUser((User)user)) {
                this.userNickMap.remove(nickLowercase);
            }
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUser(@NonNull U user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String nickLowercase = ((UserHostmask)user).getNick().toLowerCase(this.locale);
        this.wL.lock();
        try {
            this.mainMap.removeUser(user);
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                curLevelMap.removeUser(user);
            }
            this.userNickMap.remove(nickLowercase);
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean levelContainsUser(@NonNull UserLevel level, @NonNull C channel, @NonNull U user) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.rL.lock();
        try {
            boolean bl = this.levelsMap.get((Object)level).containsEntry(user, channel);
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameUser(@NonNull U user, @NonNull String newNick) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (newNick == null) {
            throw new NullPointerException("newNick is marked non-null but is null");
        }
        String oldNick = ((UserHostmask)user).getNick();
        String oldNickLowercase = oldNick.toLowerCase(this.locale);
        String newNickLowercase = newNick.toLowerCase(this.locale);
        this.wL.lock();
        try {
            ((UserHostmask)user).setNick(newNick);
            this.userNickMap.remove(oldNickLowercase);
            this.userNickMap.put(newNickLowercase, user);
        }
        finally {
            this.wL.unlock();
        }
    }

    public C getChannel(@NonNull String name) throws DaoException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Cannot get a blank channel");
        String nameLowercase = name.toLowerCase(this.locale);
        this.rL.lock();
        try {
            Channel chan = (Channel)this.channelNameMap.get(nameLowercase);
            if (chan != null) {
                Channel channel = chan;
                return (C)channel;
            }
            String modePrefixes = this.bot.getConfiguration().getUserLevelPrefixes();
            if (modePrefixes.contains(Character.toString(name.charAt(0)))) {
                String nameTrimmed = nameLowercase;
                do {
                    if ((chan = (Channel)this.channelNameMap.get(nameTrimmed = nameTrimmed.substring(1))) == null) continue;
                    Channel channel = chan;
                    return (C)channel;
                } while (modePrefixes.contains(Character.toString(nameTrimmed.charAt(0))));
            }
            throw new DaoException(DaoException.Reason.UNKNOWN_CHANNEL, name);
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C createChannel(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String nameLowercase = name.toLowerCase(this.locale);
        this.wL.lock();
        try {
            Channel chan = this.botFactory.createChannel(this.bot, name);
            this.channelNameMap.put(nameLowercase, chan);
            Channel channel = chan;
            return (C)channel;
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChannel(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String nameLowercase = name.toLowerCase(this.locale);
        this.rL.lock();
        try {
            if (this.channelNameMap.containsKey(nameLowercase)) {
                boolean bl = true;
                return bl;
            }
            String modePrefixes = this.bot.getConfiguration().getUserLevelPrefixes();
            if (modePrefixes.contains(Character.toString(name.charAt(0)))) {
                String nameTrimmed = nameLowercase;
                do {
                    if (!this.channelNameMap.containsKey(nameTrimmed = nameTrimmed.substring(1))) continue;
                    boolean bl = true;
                    return bl;
                } while (modePrefixes.contains(Character.toString(nameTrimmed.charAt(0))));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rL.unlock();
        }
    }

    public ImmutableSortedSet<U> getUsers(@NonNull C channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.rL.lock();
        try {
            ImmutableSortedSet<U> immutableSortedSet = this.mainMap.getUsers(channel);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    public ImmutableSortedSet<C> getAllChannels() {
        this.rL.lock();
        try {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf(this.channelNameMap.values());
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    public ImmutableSortedSet<C> getChannels(@NonNull U user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.rL.lock();
        try {
            ImmutableSortedSet<C> immutableSortedSet = this.mainMap.getChannels(user);
            return immutableSortedSet;
        }
        finally {
            this.rL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChannel(@NonNull C channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.wL.lock();
        try {
            this.mainMap.removeChannel(channel);
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                curLevelMap.removeChannel(channel);
            }
            this.channelNameMap.remove(((Channel)channel).getName());
        }
        finally {
            this.wL.unlock();
        }
    }

    public User getUserBot() {
        return this.getUser(this.bot.getNick());
    }

    @Override
    public void close() {
        this.wL.lock();
        try {
            this.mainMap.clear();
            for (UserChannelMap<U, C> curLevelMap : this.levelsMap.values()) {
                curLevelMap.clear();
            }
            this.channelNameMap.clear();
            this.userNickMap.clear();
        }
        finally {
            this.wL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserChannelDaoSnapshot createSnapshot() {
        this.rL.lock();
        try {
            HashMap userSnapshotMap = Maps.newHashMapWithExpectedSize((int)this.userNickMap.size());
            for (Object curUser : this.userNickMap.values()) {
                userSnapshotMap.put(curUser, ((User)curUser).createSnapshot());
            }
            HashMap channelSnapshotMap = Maps.newHashMapWithExpectedSize((int)this.channelNameMap.size());
            for (Channel curChannel : this.channelNameMap.values()) {
                channelSnapshotMap.put(curChannel, curChannel.createSnapshot());
            }
            UserChannelMapSnapshot mainMapSnapshot = this.mainMap.createSnapshot(userSnapshotMap, channelSnapshotMap);
            EnumMap<UserLevel, UserChannelMap<UserSnapshot, ChannelSnapshot>> levelsMapSnapshot = new EnumMap<UserLevel, UserChannelMap<UserSnapshot, ChannelSnapshot>>(UserLevel.class);
            for (Map.Entry<UserLevel, UserChannelMap<U, C>> entry : this.levelsMap.entrySet()) {
                levelsMapSnapshot.put((UserLevel)((Enum)entry.getKey()), entry.getValue().createSnapshot(userSnapshotMap, channelSnapshotMap));
            }
            ImmutableBiMap.Builder userNickMapSnapshotBuilder = ImmutableBiMap.builder();
            for (Map.Entry<String, U> entry : this.userNickMap.entrySet()) {
                userNickMapSnapshotBuilder.put((Object)entry.getKey(), userSnapshotMap.get(entry.getValue()));
            }
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (Map.Entry<String, C> entry : this.channelNameMap.entrySet()) {
                builder.put((Object)entry.getKey(), channelSnapshotMap.get(entry.getValue()));
            }
            UserChannelDaoSnapshot userChannelDaoSnapshot = new UserChannelDaoSnapshot(this.bot, this.locale, mainMapSnapshot, levelsMapSnapshot, (ImmutableMap<String, UserSnapshot>)userNickMapSnapshotBuilder.build(), (ImmutableMap<String, ChannelSnapshot>)builder.build());
            for (UserSnapshot curUserSnapshot : userSnapshotMap.values()) {
                curUserSnapshot.setDao(userChannelDaoSnapshot);
            }
            for (ChannelSnapshot curChannelSnapshot : channelSnapshotMap.values()) {
                curChannelSnapshot.setDao(userChannelDaoSnapshot);
            }
            UserChannelDaoSnapshot userChannelDaoSnapshot2 = userChannelDaoSnapshot;
            return userChannelDaoSnapshot2;
        }
        finally {
            this.rL.unlock();
        }
    }

    protected UserChannelDao(PircBotX bot, Configuration.BotFactory botFactory, Locale locale, UserChannelMap<U, C> mainMap, Map<UserLevel, UserChannelMap<U, C>> levelsMap, Map<String, U> userNickMap, Map<String, C> channelNameMap) {
        this.bot = bot;
        this.botFactory = botFactory;
        this.locale = locale;
        this.mainMap = mainMap;
        this.levelsMap = levelsMap;
        this.userNickMap = userNickMap;
        this.channelNameMap = channelNameMap;
    }
}

