/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelUserEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericMessageEvent;

public class ActionEvent
extends Event
implements GenericMessageEvent,
GenericChannelUserEvent {
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final Channel channel;
    protected final String channelSource;
    protected final String action;
    protected final ImmutableMap<String, String> tags;

    public ActionEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, Channel channel, @NonNull String channelSource, @NonNull String action, ImmutableMap<String, String> tags) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (channelSource == null) {
            throw new NullPointerException("channelSource is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.userHostmask = userHostmask;
        this.user = user;
        this.channel = channel;
        this.channelSource = channelSource;
        this.action = action;
        this.tags = tags;
    }

    @Override
    public String getMessage() {
        return this.action;
    }

    @Override
    public void respond(String response) {
        this.respondWith(response);
    }

    @Override
    public void respondWith(String fullLine) {
        if (this.getChannel() == null) {
            this.getUserHostmask().send().action(fullLine);
        } else {
            ((PircBotX)this.getBot()).sendIRC().action(this.channelSource, fullLine);
        }
    }

    public void respondChannel(String response) {
        if (this.getChannel() == null) {
            throw new RuntimeException("Event does not contain a channel");
        }
        ((PircBotX)this.getBot()).sendIRC().message(this.channelSource, response);
    }

    @Override
    public void respondPrivateMessage(String response) {
        this.getUser().send().message(response);
    }

    @Override
    public ImmutableMap<String, String> getV3Tags() {
        return this.tags;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public String getAction() {
        return this.action;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "ActionEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", channel=" + this.getChannel() + ", channelSource=" + this.getChannelSource() + ", action=" + this.getAction() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionEvent)) {
            return false;
        }
        ActionEvent other = (ActionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        String this$channelSource = this.getChannelSource();
        String other$channelSource = other.getChannelSource();
        if (this$channelSource == null ? other$channelSource != null : !this$channelSource.equals(other$channelSource)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ActionEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        String $channelSource = this.getChannelSource();
        result = result * 59 + ($channelSource == null ? 43 : $channelSource.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Channel getChannel() {
        return this.channel;
    }
}

