/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableList;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelEvent;

public class BanListEvent
extends Event
implements GenericChannelEvent {
    private final Channel channel;
    private final ImmutableList<Entry> entries;

    public BanListEvent(PircBotX bot, Channel channel, ImmutableList<Entry> entries) {
        super(bot);
        this.channel = channel;
        this.entries = entries;
    }

    @Override
    public void respond(String response) {
        this.channel.send().message(response);
    }

    public ImmutableList<Entry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return "BanListEvent(channel=" + this.getChannel() + ", entries=" + this.getEntries() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanListEvent)) {
            return false;
        }
        BanListEvent other = (BanListEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        ImmutableList<Entry> this$entries = this.getEntries();
        ImmutableList<Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !this$entries.equals(other$entries));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BanListEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        ImmutableList<Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : $entries.hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public static class Entry {
        private final UserHostmask recipient;
        private final UserHostmask source;
        private final long time;

        public Entry(UserHostmask recipient, UserHostmask source, long time) {
            this.recipient = recipient;
            this.source = source;
            this.time = time;
        }

        public UserHostmask getRecipient() {
            return this.recipient;
        }

        public UserHostmask getSource() {
            return this.source;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UserHostmask this$recipient = this.getRecipient();
            UserHostmask other$recipient = other.getRecipient();
            if (this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient)) {
                return false;
            }
            UserHostmask this$source = this.getSource();
            UserHostmask other$source = other.getSource();
            if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UserHostmask $recipient = this.getRecipient();
            result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
            UserHostmask $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            return result;
        }

        public String toString() {
            return "BanListEvent.Entry(recipient=" + this.getRecipient() + ", source=" + this.getSource() + ", time=" + this.getTime() + ")";
        }
    }
}

