/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericCTCPEvent;

public class PingEvent
extends Event
implements GenericCTCPEvent {
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final Channel channel;
    protected final String pingValue;

    public PingEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, Channel channel, @NonNull String pingValue) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (pingValue == null) {
            throw new NullPointerException("pingValue is marked non-null but is null");
        }
        this.userHostmask = userHostmask;
        this.user = user;
        this.channel = channel;
        this.pingValue = pingValue;
    }

    @Override
    public void respond(String response) {
        this.getUser().send().ctcpResponse(response);
    }

    public String getPingValue() {
        return this.pingValue;
    }

    public String toString() {
        return "PingEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", channel=" + this.getChannel() + ", pingValue=" + this.getPingValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PingEvent)) {
            return false;
        }
        PingEvent other = (PingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        String this$pingValue = this.getPingValue();
        String other$pingValue = other.getPingValue();
        return !(this$pingValue == null ? other$pingValue != null : !this$pingValue.equals(other$pingValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PingEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        String $pingValue = this.getPingValue();
        result = result * 59 + ($pingValue == null ? 43 : $pingValue.hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

