/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelEvent;

public class TopicEvent
extends Event
implements GenericChannelEvent {
    protected final Channel channel;
    protected final String oldTopic;
    protected final String topic;
    protected final UserHostmask user;
    protected final boolean changed;
    protected final long date;

    public TopicEvent(PircBotX bot, @NonNull Channel channel, String oldTopic, @NonNull String topic, @NonNull UserHostmask user, long date, boolean changed) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.channel = channel;
        this.oldTopic = oldTopic;
        this.topic = topic;
        this.user = user;
        this.changed = changed;
        this.date = date;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(this.user, response);
    }

    public String getOldTopic() {
        return this.oldTopic;
    }

    public String getTopic() {
        return this.topic;
    }

    public UserHostmask getUser() {
        return this.user;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public long getDate() {
        return this.date;
    }

    public String toString() {
        return "TopicEvent(channel=" + this.getChannel() + ", oldTopic=" + this.getOldTopic() + ", topic=" + this.getTopic() + ", user=" + this.getUser() + ", changed=" + this.isChanged() + ", date=" + this.getDate() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicEvent)) {
            return false;
        }
        TopicEvent other = (TopicEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        String this$oldTopic = this.getOldTopic();
        String other$oldTopic = other.getOldTopic();
        if (this$oldTopic == null ? other$oldTopic != null : !this$oldTopic.equals(other$oldTopic)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        UserHostmask this$user = this.getUser();
        UserHostmask other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        if (this.isChanged() != other.isChanged()) {
            return false;
        }
        return this.getDate() == other.getDate();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TopicEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        String $oldTopic = this.getOldTopic();
        result = result * 59 + ($oldTopic == null ? 43 : $oldTopic.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        UserHostmask $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        result = result * 59 + (this.isChanged() ? 79 : 97);
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

